/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.BuildAMoleculeResources;
import edu.colorado.phet.buildamolecule.model.Bond;
import edu.colorado.phet.buildamolecule.model.MoleculeStructure;
import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.chemistry.molecules.AtomNode;
import edu.colorado.phet.chemistry.molecules.C2H2Node;
import edu.colorado.phet.chemistry.molecules.C2H4Node;
import edu.colorado.phet.chemistry.molecules.C2H5ClNode;
import edu.colorado.phet.chemistry.molecules.C2H5OHNode;
import edu.colorado.phet.chemistry.molecules.C2H6Node;
import edu.colorado.phet.chemistry.molecules.CH2ONode;
import edu.colorado.phet.chemistry.molecules.CH3OHNode;
import edu.colorado.phet.chemistry.molecules.CH4Node;
import edu.colorado.phet.chemistry.molecules.H2ONode;
import edu.colorado.phet.chemistry.molecules.H2SNode;
import edu.colorado.phet.chemistry.molecules.HClNode;
import edu.colorado.phet.chemistry.molecules.HFNode;
import edu.colorado.phet.chemistry.molecules.HorizontalMoleculeNode;
import edu.colorado.phet.chemistry.molecules.NH3Node;
import edu.colorado.phet.chemistry.molecules.NO2Node;
import edu.colorado.phet.chemistry.molecules.OF2Node;
import edu.colorado.phet.chemistry.molecules.P4Node;
import edu.colorado.phet.chemistry.molecules.PCl3Node;
import edu.colorado.phet.chemistry.molecules.PCl5Node;
import edu.colorado.phet.chemistry.molecules.PF3Node;
import edu.colorado.phet.chemistry.molecules.PH3Node;
import edu.colorado.phet.chemistry.molecules.SO2Node;
import edu.colorado.phet.chemistry.molecules.SO3Node;
import edu.colorado.phet.common.jmolphet.Molecule;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.jmol.api.JmolViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteMolecule
extends MoleculeStructure<PubChemAtom>
implements Molecule {
    private String commonName;
    private String molecularFormula;
    public final boolean has2d;
    public final boolean has3d;
    public int cid;
    private static final Class[] nodeClasses = new Class[]{HorizontalMoleculeNode.Cl2Node.class, HorizontalMoleculeNode.CO2Node.class, HorizontalMoleculeNode.CO2Node.class, HorizontalMoleculeNode.CS2Node.class, HorizontalMoleculeNode.F2Node.class, HorizontalMoleculeNode.H2Node.class, HorizontalMoleculeNode.N2Node.class, HorizontalMoleculeNode.NONode.class, HorizontalMoleculeNode.N2ONode.class, HorizontalMoleculeNode.O2Node.class, C2H2Node.class, C2H4Node.class, C2H5ClNode.class, C2H5OHNode.class, C2H6Node.class, CH2ONode.class, CH3OHNode.class, CH4Node.class, H2ONode.class, H2SNode.class, HClNode.class, HFNode.class, NH3Node.class, NO2Node.class, OF2Node.class, P4Node.class, PCl3Node.class, PCl5Node.class, PF3Node.class, PH3Node.class, SO2Node.class, SO3Node.class};

    public CompleteMolecule(String string, String string2, int n, int n2, boolean bl, boolean bl2) {
        super(n, n2);
        this.commonName = string;
        this.molecularFormula = string2;
        this.has2d = bl;
        this.has3d = bl2;
    }

    public String getCommonName() {
        String string = this.commonName;
        if (string.startsWith("molecular ")) {
            string = string.substring("molecular ".length());
        }
        return this.capitalize(string);
    }

    public String getStringKey() {
        return "molecule." + this.commonName.replace(' ', '_');
    }

    @Override
    public String getDisplayName() {
        String string = this.getStringKey();
        String string2 = BuildAMoleculeResources.getResourceLoader().getLocalizedProperties().getString(string, false);
        if (string2 != null && !string2.equals(string)) {
            return string2;
        }
        return this.getCommonName();
    }

    public int getCID() {
        return this.cid;
    }

    private String capitalize(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c)) {
                bl = true;
                continue;
            }
            if (bl && Character.isLetter(c) && Character.isLowerCase(c)) {
                cArray[i] = Character.toUpperCase(c);
            }
            bl = false;
        }
        return String.valueOf(cArray);
    }

    @Override
    public String getData() {
        String string = "<?xml version=\"1.0\"?>\n<molecule id=\"" + this.commonName + "\" xmlns=\"http://www.xml-cml.org/schema\">";
        string = string + "<name>" + this.commonName + "</name>";
        string = string + "<atomArray>";
        for (int i = 0; i < this.getAtoms().size(); ++i) {
            PubChemAtom object = (PubChemAtom)this.getAtoms().get(i);
            string = string + "<atom id=\"a" + i + "\" elementType=\"" + object.getSymbol() + "\" x3=\"" + object.getX3d() + "\" y3=\"" + object.getY3d() + "\" z3=\"" + object.getZ3d() + "\"/>";
        }
        string = string + "</atomArray>";
        string = string + "<bondArray>";
        for (Bond bond : this.getBonds()) {
            PubChemBond pubChemBond = (PubChemBond)bond;
            string = string + "<bond atomRefs2=\"a" + this.getAtoms().indexOf(pubChemBond.a) + " a" + this.getAtoms().indexOf(pubChemBond.b) + "\" order=\"" + pubChemBond.order + "\"/>";
        }
        string = string + "</bondArray>";
        string = string + "</molecule>";
        return string;
    }

    @Override
    public void fixJmolColors(JmolViewer jmolViewer) {
        for (int i = 0; i < this.getAtoms().size(); ++i) {
            Color color = ((PubChemAtom)this.getAtoms().get(i)).getColor();
            jmolViewer.script("select a" + i + ";  color [" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "];");
        }
        jmolViewer.script("select all;");
    }

    public PNode createPseudo3DNode() {
        for (Class clazz : nodeClasses) {
            if (!clazz.getSimpleName().equals(this.molecularFormula + "Node") && (clazz != NH3Node.class || !this.molecularFormula.equals("H3N"))) continue;
            try {
                return (PNode)clazz.getConstructors()[0].newInstance(new Object[0]);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return new PNode(){
            {
                ArrayList arrayList = new ArrayList(CompleteMolecule.this.getAtoms());
                Collections.sort(arrayList, new Comparator<PubChemAtom>(){

                    @Override
                    public int compare(PubChemAtom pubChemAtom, PubChemAtom pubChemAtom2) {
                        return new Float(pubChemAtom.getZ3d()).compareTo(Float.valueOf(pubChemAtom2.getZ3d()));
                    }
                });
                for (final PubChemAtom pubChemAtom : arrayList) {
                    this.addChild(new AtomNode(pubChemAtom.getElement()){
                        {
                            super(element);
                            this.setOffset(pubChemAtom.getX2d() * 15.0f, pubChemAtom.getY2d() * 15.0f);
                        }
                    });
                }
            }
        };
    }

    @Override
    public String toSerial2() {
        String string = this.has3d ? (this.has2d ? "full" : "3d") : "2d";
        return this.commonName + "|" + this.molecularFormula + "|" + this.cid + "|" + string + "|" + super.toSerial2();
    }

    public static CompleteMolecule fromSerial2(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        final String string2 = stringTokenizer.nextToken();
        final String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        final int n = Integer.parseInt(string4);
        String string5 = stringTokenizer.nextToken();
        boolean bl = string5.equals("full");
        final boolean bl2 = string5.equals("2d") || bl;
        final boolean bl3 = string5.equals("3d") || bl;
        int n2 = string2.length() + 1 + string3.length() + 1 + string4.length() + 1 + string5.length() + 1;
        MoleculeStructure.AtomParser<PubChemAtom> atomParser = bl3 ? (bl ? PubChemAtomFull.getAtomParser() : PubChemAtom3d.getAtomParser()) : PubChemAtom2d.getAtomParser();
        return MoleculeStructure.fromSerial2(string.substring(n2), new MoleculeStructure.MoleculeGenerator<PubChemAtom, CompleteMolecule>(){

            @Override
            public CompleteMolecule createMolecule(int n3, int n2) {
                CompleteMolecule completeMolecule = new CompleteMolecule(string2, string3, n3, n2, bl2, bl3);
                completeMolecule.cid = n;
                return completeMolecule;
            }
        }, atomParser, PubChemBond.getBondParser());
    }

    private static String stringFloat(float f) {
        if (f == 0.0f) {
            return "0";
        }
        return String.valueOf(f);
    }

    public static abstract class PubChemAtom
    extends Atom {
        protected PubChemAtom(Element element) {
            super(element);
        }

        public float getX2d() {
            return 0.0f;
        }

        public float getY2d() {
            return 0.0f;
        }

        public float getX3d() {
            return 0.0f;
        }

        public float getY3d() {
            return 0.0f;
        }

        public float getZ3d() {
            return 0.0f;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PubChemAtom2d
    extends PubChemAtom {
        private final float x2d;
        private final float y2d;

        public PubChemAtom2d(Element element, float f, float f2) {
            super(element);
            this.x2d = f;
            this.y2d = f2;
        }

        @Override
        public float getX2d() {
            return this.x2d;
        }

        @Override
        public float getY2d() {
            return this.y2d;
        }

        @Override
        public float getX3d() {
            return this.getX2d();
        }

        @Override
        public float getY3d() {
            return this.getY2d();
        }

        @Override
        public String toString() {
            return super.toString() + " " + CompleteMolecule.stringFloat(this.x2d) + " " + CompleteMolecule.stringFloat(this.y2d);
        }

        public static MoleculeStructure.AtomParser<PubChemAtom> getAtomParser() {
            return new MoleculeStructure.AtomParser<PubChemAtom>(){

                @Override
                public PubChemAtom parseAtom(String string) {
                    String[] stringArray = string.split(" ");
                    return new PubChemAtom2d(Element.getElementBySymbol(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PubChemAtom3d
    extends PubChemAtom {
        private final float x3d;
        private final float y3d;
        private final float z3d;

        public PubChemAtom3d(Element element, float f, float f2, float f3) {
            super(element);
            this.x3d = f;
            this.y3d = f2;
            this.z3d = f3;
        }

        @Override
        public float getX3d() {
            return this.x3d;
        }

        @Override
        public float getY3d() {
            return this.y3d;
        }

        @Override
        public float getZ3d() {
            return this.z3d;
        }

        @Override
        public String toString() {
            return super.toString() + " " + CompleteMolecule.stringFloat(this.x3d) + " " + CompleteMolecule.stringFloat(this.y3d) + " " + CompleteMolecule.stringFloat(this.z3d);
        }

        public static MoleculeStructure.AtomParser<PubChemAtom> getAtomParser() {
            return new MoleculeStructure.AtomParser<PubChemAtom>(){

                @Override
                public PubChemAtom parseAtom(String string) {
                    String[] stringArray = string.split(" ");
                    return new PubChemAtom3d(Element.getElementBySymbol(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]));
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PubChemAtomFull
    extends PubChemAtom {
        private final float x2d;
        private final float y2d;
        private final float x3d;
        private final float y3d;
        private final float z3d;

        public PubChemAtomFull(Element element, float f, float f2, float f3, float f4, float f5) {
            super(element);
            this.x2d = f;
            this.y2d = f2;
            this.x3d = f3;
            this.y3d = f4;
            this.z3d = f5;
        }

        @Override
        public float getX2d() {
            return this.x2d;
        }

        @Override
        public float getY2d() {
            return this.y2d;
        }

        @Override
        public float getX3d() {
            return this.x3d;
        }

        @Override
        public float getY3d() {
            return this.y3d;
        }

        @Override
        public float getZ3d() {
            return this.z3d;
        }

        @Override
        public String toString() {
            return super.toString() + " " + CompleteMolecule.stringFloat(this.x2d) + " " + CompleteMolecule.stringFloat(this.y2d) + " " + CompleteMolecule.stringFloat(this.x3d) + " " + CompleteMolecule.stringFloat(this.y3d) + " " + CompleteMolecule.stringFloat(this.z3d);
        }

        public static MoleculeStructure.AtomParser<PubChemAtom> getAtomParser() {
            return new MoleculeStructure.AtomParser<PubChemAtom>(){

                @Override
                public PubChemAtom parseAtom(String string) {
                    String[] stringArray = string.split(" ");
                    return new PubChemAtomFull(Element.getElementBySymbol(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]), Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5]));
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PubChemBond
    extends Bond<PubChemAtom> {
        public final int order;

        public PubChemBond(PubChemAtom pubChemAtom, PubChemAtom pubChemAtom2, int n) {
            super(pubChemAtom, pubChemAtom2);
            this.order = n;
        }

        @Override
        public String toSerial2(int n) {
            return n + "-" + this.order;
        }

        public static MoleculeStructure.BondParser<PubChemAtom, PubChemBond> getBondParser() {
            return new MoleculeStructure.BondParser<PubChemAtom, PubChemBond>(){

                @Override
                public PubChemBond parseBond(String string, PubChemAtom pubChemAtom, MoleculeStructure<PubChemAtom> moleculeStructure) {
                    String[] stringArray = string.split("-");
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    return new PubChemBond(pubChemAtom, moleculeStructure.getAtoms().get(n), n2);
                }
            };
        }
    }
}

