/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.BuildAMoleculeApplication;
import edu.colorado.phet.buildamolecule.model.CompleteMolecule;
import edu.colorado.phet.buildamolecule.model.Molecule;
import edu.colorado.phet.buildamolecule.model.MoleculeStructure;
import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionBox {
    private final CompleteMolecule moleculeType;
    private final int capacity;
    public final Property<Integer> quantity = new Property<Integer>(0);
    private Rectangle2D dropBounds;
    private List<Listener> listeners = new LinkedList<Listener>();
    private Set<Molecule> molecules = new HashSet<Molecule>();

    public CollectionBox(CompleteMolecule completeMolecule, final int n) {
        this.moleculeType = completeMolecule;
        this.capacity = n;
        this.addListener(new Adapter(){

            public void onAddedMolecule(Molecule molecule) {
                if (CollectionBox.this.quantity.get() == n) {
                    BuildAMoleculeApplication.playCollectionBoxFilledSound();
                }
            }
        });
    }

    public CompleteMolecule getMoleculeType() {
        return this.moleculeType;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setDropBounds(Rectangle2D rectangle2D) {
        assert (rectangle2D != null);
        this.dropBounds = rectangle2D;
    }

    public Rectangle2D getDropBounds() {
        return this.dropBounds;
    }

    public boolean isFull() {
        return this.capacity == this.quantity.get();
    }

    public <U extends Atom> boolean willAllowMoleculeDrop(MoleculeStructure<U> moleculeStructure) {
        boolean bl = this.getMoleculeType().isEquivalent(moleculeStructure);
        return bl && this.quantity.get() < this.capacity;
    }

    public void addMolecule(Molecule molecule) {
        this.quantity.set(this.quantity.get() + 1);
        this.molecules.add(molecule);
        for (Listener listener : this.listeners) {
            listener.onAddedMolecule(molecule);
        }
    }

    public void removeMolecule(Molecule molecule) {
        this.quantity.set(this.quantity.get() - 1);
        this.molecules.remove(molecule);
        for (Listener listener : this.listeners) {
            listener.onRemovedMolecule(molecule);
        }
    }

    public void onAcceptedMoleculeCreation(Molecule molecule) {
        for (Listener listener : this.listeners) {
            listener.onAcceptedMoleculeCreation(molecule);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void clear() {
        for (Molecule molecule : new ArrayList<Molecule>(this.molecules)) {
            this.removeMolecule(molecule);
        }
    }

    public static class Adapter
    implements Listener {
        public void onAddedMolecule(Molecule molecule) {
        }

        public void onRemovedMolecule(Molecule molecule) {
        }

        public void onAcceptedMoleculeCreation(Molecule molecule) {
        }
    }

    public static interface Listener {
        public void onAddedMolecule(Molecule var1);

        public void onRemovedMolecule(Molecule var1);

        public void onAcceptedMoleculeCreation(Molecule var1);
    }
}

