/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.IBucketSphere;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.util.PBounds;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Atom2D
extends Atom
implements IBucketSphere<Atom2D> {
    private final String name;
    public final Property<Vector2D> position;
    private final Property<Boolean> userControlled = new Property<Boolean>(false);
    private final HashSet<IBucketSphere.Listener<Atom2D>> listeners = new HashSet();
    private Vector2D destination = new Vector2D();
    public final Property<Boolean> visible = new Property<Boolean>(true);
    private final ClockAdapter clockListener = new ClockAdapter(){

        public void clockTicked(ClockEvent clockEvent) {
            Atom2D.this.stepInTime(clockEvent.getSimulationTimeChange());
        }
    };
    private final IClock clock;

    public Atom2D(Element element, IClock iClock) {
        super(element);
        this.clock = iClock;
        this.name = BuildAMoleculeStrings.getAtomName(element);
        this.position = new Property<Vector2D>(new Vector2D());
        this.destination = this.position.get();
        this.addedToModel();
        this.userControlled.addObserver(new SimpleObserver(){

            public void update() {
                ArrayList arrayList = new ArrayList(Atom2D.this.listeners);
                if (((Boolean)Atom2D.this.userControlled.get()).booleanValue()) {
                    for (IBucketSphere.Listener listener : arrayList) {
                        listener.grabbedByUser(Atom2D.this);
                    }
                } else {
                    for (IBucketSphere.Listener listener : arrayList) {
                        listener.droppedByUser(Atom2D.this);
                    }
                }
            }
        });
    }

    @Override
    public void addListener(IBucketSphere.Listener<Atom2D> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IBucketSphere.Listener<Atom2D> listener) {
        this.listeners.remove(listener);
    }

    public PBounds getPositionBounds() {
        return new PBounds(this.position.get().getX() - this.getRadius(), this.position.get().getY() - this.getRadius(), this.getDiameter(), this.getDiameter());
    }

    public PBounds getDestinationBounds() {
        return new PBounds(this.destination.getX() - this.getRadius(), this.destination.getY() - this.getRadius(), this.getDiameter(), this.getDiameter());
    }

    private void stepInTime(double d) {
        if (this.getPosition().distance(this.destination) != 0.0) {
            double d2;
            double d3;
            double d4 = 800.0 * d;
            double d5 = this.getPosition().distance(this.destination);
            if (d5 > d4 * (d3 = 10.0)) {
                d2 = d5 - d4 * d3;
                d4 *= 1.0 + d2 / 300.0;
            }
            if (d4 >= d5) {
                this.setPosition(this.destination);
            } else {
                d2 = Math.atan2(this.destination.getY() - this.getPosition().getY(), this.destination.getX() - this.getPosition().getX());
                this.translate(d4 * Math.cos(d2), d4 * Math.sin(d2));
            }
        }
    }

    @Override
    public Vector2D getPosition() {
        return this.position.get();
    }

    @Override
    public Vector2D getDestination() {
        return this.destination;
    }

    public void setPosition(Vector2D vector2D) {
        this.position.set(vector2D);
    }

    public void setPosition(double d, double d2) {
        this.position.set(new Vector2D(d, d2));
    }

    @Override
    public void setDestination(Vector2D vector2D) {
        this.destination = vector2D;
    }

    public void translatePositionAndDestination(Vector2D vector2D) {
        this.setPosition(this.getPosition().plus(vector2D));
        this.setDestination(this.getDestination().plus(vector2D));
    }

    @Override
    public void setPositionAndDestination(Vector2D vector2D) {
        this.setPosition(vector2D);
        this.setDestination(vector2D);
    }

    public void setUserControlled(boolean bl) {
        this.userControlled.set(bl);
    }

    public void translate(double d, double d2) {
        this.setPosition(this.position.get().getX() + d, this.position.get().getY() + d2);
    }

    public void reset() {
        this.position.reset();
        this.destination = this.position.get();
        this.userControlled.reset();
        this.visible.reset();
    }

    public void addedToModel() {
        if (this.clock != null) {
            this.clock.addClockListener(this.clockListener);
        }
    }

    @Override
    public void addPositionListener(SimpleObserver simpleObserver) {
        this.position.addObserver(simpleObserver);
    }

    @Override
    public void removePositionListener(SimpleObserver simpleObserver) {
        this.position.removeObserver(simpleObserver);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends IBucketSphere.Adapter<Atom2D>
    implements Listener {
    }

    public static interface Listener
    extends IBucketSphere.Listener {
    }
}

