/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusNode;
import java.awt.geom.Point2D;

public class LabeledNucleusSphereNode
extends LabeledNucleusNode {
    public LabeledNucleusSphereNode(NucleusDisplayInfo nucleusDisplayInfo) {
        super(nucleusDisplayInfo);
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint(6.25, -6.25, this.getHighlightColor(nucleusDisplayInfo.getDisplayColor()), new Point2D.Double(12.5, 12.5), nucleusDisplayInfo.getDisplayColor());
        SphericalNode sphericalNode = new SphericalNode(50.0, roundGradientPaint, false);
        sphericalNode.setOffset(25.0, 25.0);
        this.getRepresentationLayer().addChild(sphericalNode);
        double d = sphericalNode.getFullBoundsReference().getWidth();
        ShadowHTMLNode shadowHTMLNode = this.getLabel();
        double d2 = Math.min(d / shadowHTMLNode.getFullBoundsReference().getWidth() * 0.9, d / shadowHTMLNode.getFullBoundsReference().getHeight());
        shadowHTMLNode.setScale(d2);
        shadowHTMLNode.setOffset((d - shadowHTMLNode.getFullBoundsReference().getWidth()) / 2.0, (sphericalNode.getFullBoundsReference().getHeight() - shadowHTMLNode.getFullBoundsReference().getHeight()) / 2.0);
    }
}

