/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HandleNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.ControlRod;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.NuclearReactorModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.geom.GeneralPath;

public class ControlRodAdjusterNode
extends PNode {
    private static final Color CONTROL_ROD_ADJUSTER_COLOR = new Color(0x66CC00);
    private static final BasicStroke HANDLE_STROKE = new BasicStroke(1.2f);
    private static final Color HANDLE_COLOR = Color.DARK_GRAY;
    private NuclearReactorModel _nuclearReactorModel;
    private HandleNode _handle;

    public ControlRodAdjusterNode(NuclearReactorModel nuclearReactorModel) {
        this._nuclearReactorModel = nuclearReactorModel;
        ControlRod controlRod = (ControlRod)this._nuclearReactorModel.getControlRodsReference().get(0);
        controlRod.addListener(new ControlRod.Listener(){

            public void positionChanged() {
                ControlRod controlRod = (ControlRod)ControlRodAdjusterNode.this._nuclearReactorModel.getControlRodsReference().get(0);
                ControlRodAdjusterNode.this.setOffsetBasedOnControlRod(controlRod);
            }
        });
        float f = (float)controlRod.getRectangleReference().getWidth();
        float f2 = (float)(controlRod.getRectangleReference().getHeight() + (double)f);
        float f3 = (float)(this._nuclearReactorModel.getReactorRect().getWidth() - (controlRod.getPosition().getX() - this._nuclearReactorModel.getReactorRect().getX()) + 1.5 * this._nuclearReactorModel.getReactorWallWidth());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(f3 - f, 0.0f);
        generalPath.lineTo(f3 - f, -(f2 - f));
        generalPath.lineTo(f3, -(f2 - f));
        generalPath.lineTo(f3, f);
        generalPath.lineTo(0.0f, f);
        generalPath.lineTo(0.0f, 0.0f);
        PPath pPath = new PPath(generalPath);
        pPath.setPaint(CONTROL_ROD_ADJUSTER_COLOR);
        this.addChild(pPath);
        this.addInputEventListener(new PDragEventHandler(){

            public void drag(PInputEvent pInputEvent) {
                ControlRodAdjusterNode.this.handleDragEvent(pInputEvent);
            }
        });
        this.addInputEventListener(new CursorHandler(8));
        GradientPaint gradientPaint = new GradientPaint(0.0f, 25.0f, Color.white, 37.5f, 25.0f, HANDLE_COLOR);
        this._handle = new HandleNode(25.0, 50.0, 12.0, 15.0, gradientPaint, Color.BLACK, HANDLE_STROKE);
        this._handle.rotate(Math.PI);
        this._handle.addInputEventListener(new CursorHandler(8));
        this._handle.setOffset(f3 + 25.0f, (double)(-f2) + 50.0 + (double)(2.0f * f));
        this._handle.setPaint(Color.RED);
        this.addChild(this._handle);
        PText pText = new PText(NuclearPhysicsStrings.CONTROL_ROD_ADJUSTER_LABEL);
        pText.setFont(new Font(NuclearPhysicsConstants.DEFAULT_FONT_NAME, 1, 14));
        pText.rotate(-1.5707963267948966);
        this.addChild(pText);
        pText.setOffset(f3 - f, (double)(-(f2 / 3.0f)) + pText.getWidth() / 2.0);
        this.setOffsetBasedOnControlRod(controlRod);
    }

    private void setOffsetBasedOnControlRod(ControlRod controlRod) {
        this.setOffset(controlRod.getPosition().getX(), controlRod.getPosition().getY() + controlRod.getRectangleReference().getHeight());
    }

    private void handleDragEvent(PInputEvent pInputEvent) {
        double d = pInputEvent.getDelta().height;
        this._nuclearReactorModel.moveControlRods(d);
    }
}

