/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.DoubleArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.ResizeArrowNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import edu.colorado.phet.nuclearphysics.model.AlphaDecayCompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.CompositeAtomicNucleus;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.module.alphadecay.singlenucleus.SingleNucleusAlphaDecayCanvas;
import edu.colorado.phet.nuclearphysics.module.alphadecay.singlenucleus.SingleNucleusAlphaDecayModel;
import edu.colorado.phet.nuclearphysics.view.AlphaParticleNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.nodes.PLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public class AlphaDecayEnergyChart
extends PNode
implements SubatomicParticle.Listener {
    private static final Color BORDER_COLOR = Color.DARK_GRAY;
    private static final Stroke BORDER_STROKE = new BasicStroke(6.0f);
    private static final Color BACKGROUND_COLOR = new Color(246, 242, 175);
    private static final Color AXES_LINE_COLOR = Color.BLACK;
    private static final Stroke ENERGY_LINE_STROKE = new BasicStroke(2.0f, 1, 0, 1.0f);
    private static final Stroke REFERENCE_LINE_STROKE = new BasicStroke(2.0f, 1, 0, 1.0f, new float[]{9.0f}, 11.0f);
    private static final Color TOTAL_ENERGY_LINE_COLOR = Color.RED;
    private static final Color POTENTIAL_ENERGY_LINE_COLOR = Color.BLUE;
    private static final Color LEGEND_BORDER_COLOR = Color.GRAY;
    private static final Stroke LEGEND_BORDER_STROKE = new BasicStroke(2.0f);
    private static final Color LEGEND_BACKGROUND_COLOR = BACKGROUND_COLOR;
    private static final Stroke CONTROL_HANDLE_STROKE = new BasicStroke(0.4f);
    private final SingleNucleusAlphaDecayModel _model;
    private final SingleNucleusAlphaDecayCanvas _canvas;
    private AlphaParticle _tunneledAlpha;
    private final ArrayList _alphaParticles = new ArrayList();
    private final ArrayList _currentlyTrackedAlphas = new ArrayList(6);
    private double _energyWellWidth;
    private final PPath _borderNode;
    private final PLine _totalEnergyLine;
    private final PPath _potentialEnergyLine;
    private final DoubleArrowNode _xAxisOfGraph;
    private final ArrowNode _yAxisOfGraph;
    private final PText _yAxisLabel;
    private final PText _xAxisLabel;
    private final GraphLegend _legend;
    private final PImage _tunneledAlphaParticleImage;
    private final PImage[] _alphaParticleImages = new PImage[6];
    private final ResizeArrowNode _totalEnergyHandle;
    private final ResizeArrowNode _potentialEnergyPeakHandle;
    private final PLine _potentialEnergyPeakRefLine;
    private double _usableAreaOriginX;
    private double _usableAreaOriginY;
    private double _usableWidth;
    private double _usableHeight;
    private double _graphOriginX;
    private double _graphOriginY;
    private boolean _decayOccurred = false;
    private double _totalEnergy;
    private double _potentialEnergyPeak;
    private double _potentialEnergyMinimum;
    private double _energyWellBottom;
    private boolean _interactivityEnabled = false;

    public AlphaDecayEnergyChart(SingleNucleusAlphaDecayModel singleNucleusAlphaDecayModel, SingleNucleusAlphaDecayCanvas singleNucleusAlphaDecayCanvas) {
        this._model = singleNucleusAlphaDecayModel;
        this._canvas = singleNucleusAlphaDecayCanvas;
        this._totalEnergy = 8.0;
        this._potentialEnergyMinimum = 1.0;
        this._potentialEnergyPeak = 14.0;
        this._energyWellBottom = -37.0;
        this._model.addListener(new NuclearDecayListenerAdapter(){

            public void nucleusTypeChanged() {
                if (AlphaDecayEnergyChart.this._model.getNucleusType() == NucleusType.HEAVY_CUSTOM) {
                    AlphaDecayEnergyChart.this._interactivityEnabled = true;
                    AlphaDecayEnergyChart.this._totalEnergy = 16.0;
                    AlphaDecayEnergyChart.this._potentialEnergyMinimum = 1.0;
                    AlphaDecayEnergyChart.this._potentialEnergyPeak = 22.0;
                    AlphaDecayEnergyChart.this.updateCustomNucleusHalfLife();
                } else {
                    AlphaDecayEnergyChart.this._interactivityEnabled = false;
                    AlphaDecayEnergyChart.this._totalEnergy = 8.0;
                    AlphaDecayEnergyChart.this._potentialEnergyMinimum = 1.0;
                    AlphaDecayEnergyChart.this._potentialEnergyPeak = 14.0;
                }
                AlphaDecayEnergyChart.this.update();
            }

            public void modelElementAdded(Object object) {
                AlphaDecayEnergyChart.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                AlphaDecayEnergyChart.this.handleModelElementRemoved(object);
            }
        });
        if (this._model.getNucleusType() == NucleusType.HEAVY_CUSTOM) {
            this.updateCustomNucleusHalfLife();
        }
        this._borderNode = new PPath();
        this._borderNode.setStroke(BORDER_STROKE);
        this._borderNode.setStrokePaint(BORDER_COLOR);
        this._borderNode.setPaint(BACKGROUND_COLOR);
        this.addChild(this._borderNode);
        this._xAxisOfGraph = new DoubleArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 100.0), 10.0, 8.0, 0.5);
        this._xAxisOfGraph.setPaint(AXES_LINE_COLOR);
        this._xAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
        this.addChild(this._xAxisOfGraph);
        this._yAxisOfGraph = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 100.0), 10.0, 8.0, 0.5);
        this._yAxisOfGraph.setPaint(AXES_LINE_COLOR);
        this._yAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
        this.addChild(this._yAxisOfGraph);
        this._totalEnergyLine = new PLine();
        this._totalEnergyLine.setStrokePaint(TOTAL_ENERGY_LINE_COLOR);
        this._totalEnergyLine.setStroke(ENERGY_LINE_STROKE);
        this.addChild(this._totalEnergyLine);
        this._potentialEnergyLine = new PPath(){

            public void paint(PPaintContext pPaintContext) {
                Graphics2D graphics2D = pPaintContext.getGraphics();
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                super.paint(pPaintContext);
                graphics2D.setRenderingHints(renderingHints);
            }
        };
        this._potentialEnergyLine.setStrokePaint(POTENTIAL_ENERGY_LINE_COLOR);
        this._potentialEnergyLine.setStroke(ENERGY_LINE_STROKE);
        this.addChild(this._potentialEnergyLine);
        this._potentialEnergyPeakRefLine = new PLine();
        this._potentialEnergyPeakRefLine.setStrokePaint(POTENTIAL_ENERGY_LINE_COLOR);
        this._potentialEnergyPeakRefLine.setStroke(REFERENCE_LINE_STROKE);
        this.addChild(this._potentialEnergyPeakRefLine);
        this._totalEnergyHandle = new ResizeArrowNode(20.0, 1.5707963267948966, Color.GREEN, Color.YELLOW);
        this._totalEnergyHandle.setPickable(true);
        this._totalEnergyHandle.setChildrenPickable(true);
        this._totalEnergyHandle.setStroke(CONTROL_HANDLE_STROKE);
        this.addChild(this._totalEnergyHandle);
        this._totalEnergyHandle.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                AlphaDecayEnergyChart.this._model.setPaused(true);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                AlphaDecayEnergyChart.this._model.setPaused(false);
                AlphaDecayEnergyChart.this._model.resetNucleus();
                AlphaDecayEnergyChart.this._canvas.autoPressResetButton();
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(AlphaDecayEnergyChart.this._totalEnergyHandle);
                double d = AlphaDecayEnergyChart.this._totalEnergy + -pDimension.getHeight() * AlphaDecayEnergyChart.this._totalEnergyHandle.getScale() * 100.0 / AlphaDecayEnergyChart.this._usableHeight;
                if (d >= AlphaDecayEnergyChart.this._energyWellBottom * 0.67 && AlphaDecayEnergyChart.this.convertEnergyToPixels(d) > AlphaDecayEnergyChart.this._usableAreaOriginY + 6.0) {
                    AlphaDecayEnergyChart.this._totalEnergy = d;
                    AlphaDecayEnergyChart.this.updateEnergyLines();
                    AlphaDecayEnergyChart.this._model.setHalfLife(AlphaDecayEnergyChart.this.calculateHalfLife());
                }
            }
        });
        this._potentialEnergyPeakHandle = new ResizeArrowNode(20.0, 1.5707963267948966, Color.GREEN, Color.YELLOW);
        this._potentialEnergyPeakHandle.setPickable(true);
        this._potentialEnergyPeakHandle.setChildrenPickable(true);
        this._potentialEnergyPeakHandle.setStroke(CONTROL_HANDLE_STROKE);
        this.addChild(this._potentialEnergyPeakHandle);
        this._potentialEnergyPeakHandle.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                AlphaDecayEnergyChart.this._model.setPaused(true);
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                AlphaDecayEnergyChart.this._model.setPaused(false);
                AlphaDecayEnergyChart.this._model.resetNucleus();
                AlphaDecayEnergyChart.this._canvas.autoPressResetButton();
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(AlphaDecayEnergyChart.this._potentialEnergyPeakHandle);
                double d = AlphaDecayEnergyChart.this._potentialEnergyPeak + -pDimension.getHeight() * AlphaDecayEnergyChart.this._potentialEnergyPeakHandle.getScale() * 100.0 / AlphaDecayEnergyChart.this._usableHeight;
                if (d >= 1.0 && AlphaDecayEnergyChart.this.convertEnergyToPixels(d) > AlphaDecayEnergyChart.this._usableAreaOriginY + 6.0) {
                    AlphaDecayEnergyChart.this._potentialEnergyPeak = d;
                    AlphaDecayEnergyChart.this.updateEnergyLines();
                    AlphaDecayEnergyChart.this.calculateHalfLife();
                    AlphaDecayEnergyChart.this._model.setHalfLife(AlphaDecayEnergyChart.this.calculateHalfLife());
                }
            }
        });
        this._yAxisLabel = new PText(NuclearPhysicsStrings.POTENTIAL_PROFILE_Y_AXIS_LABEL_2);
        this._yAxisLabel.setFont(new PhetFont(0, 14));
        this._yAxisLabel.rotate(4.71238898038469);
        this.addChild(this._yAxisLabel);
        this._xAxisLabel = new PText(NuclearPhysicsStrings.DECAY_ENERGY_PROFILE_X_AXIS_LABEL);
        this._xAxisLabel.setFont(new PhetFont(0, 14));
        this.addChild(this._xAxisLabel);
        this._legend = new GraphLegend();
        this.addChild(this._legend);
        for (int i = 0; i < 6; ++i) {
            AlphaParticleNode alphaParticleNode = new AlphaParticleNode();
            alphaParticleNode.scale(7.0);
            this._alphaParticleImages[i] = new PImage(alphaParticleNode.toImage());
            this._alphaParticleImages[i].setVisible(true);
            this.addChild(this._alphaParticleImages[i]);
        }
        AlphaParticleNode alphaParticleNode = new AlphaParticleNode();
        alphaParticleNode.scale(7.0);
        this._tunneledAlphaParticleImage = new PImage(alphaParticleNode.toImage());
        this._tunneledAlphaParticleImage.setVisible(false);
        this.addChild(this._tunneledAlphaParticleImage);
    }

    private void updateCustomNucleusHalfLife() {
        if (this._model.getNucleusType() == NucleusType.HEAVY_CUSTOM) {
            this._model.setHalfLife(this.calculateHalfLife());
        }
    }

    public void componentResized(Rectangle2D rectangle2D) {
        this.updateBounds(rectangle2D);
    }

    private void updateBounds(Rectangle2D rectangle2D) {
        this._usableAreaOriginX = rectangle2D.getX() + 6.0;
        this._usableAreaOriginY = rectangle2D.getY() + 6.0;
        this._usableWidth = rectangle2D.getWidth() - 12.0;
        this._usableHeight = rectangle2D.getHeight() - 12.0;
        this._graphOriginX = this._usableWidth * 0.05 + this._usableAreaOriginX;
        this._graphOriginY = this.convertEnergyToPixels(0.0);
        double d = this._model.getAtomNucleus().getDiameter();
        PDimension pDimension = new PDimension(d, d);
        this._canvas.getPhetRootNode().worldToScreen(pDimension);
        this._energyWellWidth = pDimension.getWidth();
        this.update();
    }

    private void update() {
        if (this._usableWidth <= 0.0 || this._usableHeight <= 0.0) {
            return;
        }
        this._borderNode.setPathTo(new RoundRectangle2D.Double(this._usableAreaOriginX, this._usableAreaOriginY, this._usableWidth, this._usableHeight, 20.0, 20.0));
        Point2D.Double double_ = new Point2D.Double(this._usableAreaOriginX + 6.0, this._graphOriginY);
        Point2D.Double double_2 = new Point2D.Double(this._usableAreaOriginX + this._usableWidth - 6.0, this._graphOriginY);
        this._xAxisOfGraph.setTipAndTailLocations(double_, double_2);
        Point2D.Double double_3 = new Point2D.Double(this._graphOriginX, this._usableAreaOriginY + 6.0);
        Point2D.Double double_4 = new Point2D.Double(this._graphOriginX, this._usableAreaOriginY + this._usableHeight - 6.0);
        this._yAxisOfGraph.setTipAndTailLocations(double_3, double_4);
        this._yAxisLabel.setOffset(this._graphOriginX - 1.5 * (double)this._yAxisLabel.getFont().getSize(), this._graphOriginY + 0.5 * (((Point2D)double_4).getY() - this._graphOriginY + this._yAxisLabel.getWidth()));
        this._xAxisLabel.setOffset(this._graphOriginX + 15.0, this._graphOriginY + 3.0);
        this.updateEnergyLines();
        double d = Math.min(0.5 * this._usableHeight, this._usableHeight - this._graphOriginY - this._xAxisLabel.getFullBounds().height - 8.0);
        double d2 = 0.27 * this._usableWidth;
        this._legend.updateSize(d2, d);
        this._legend.setOffset(this._usableAreaOriginX + this._usableWidth * 0.06, this._usableAreaOriginY + this._usableHeight - d - 8.0);
        this.refreshAlphaImages();
    }

    private double convertEnergyToPixels(double d) {
        double d2 = this._usableHeight / 100.0;
        if (d2 > 0.0) {
            return this._usableHeight - (d + 55.0) * d2 + this._usableAreaOriginY;
        }
        return 0.0;
    }

    private double convertPixelsToDistance(double d) {
        PDimension pDimension = new PDimension(d, d);
        this._canvas.getPhetRootNode().screenToWorld(pDimension);
        return pDimension.width;
    }

    private void updateEnergyLines() {
        double d = this._usableAreaOriginX + this._usableWidth / 2.0;
        this._potentialEnergyLine.reset();
        this._potentialEnergyLine.moveTo((float)this._usableAreaOriginX + 18.0f, (float)this.convertEnergyToPixels(this._potentialEnergyMinimum));
        this._potentialEnergyLine.quadTo((float)(d - this._energyWellWidth / 2.0 - 25.0), (float)this.convertEnergyToPixels(0.0), (float)(d - this._energyWellWidth / 2.0), (float)this.convertEnergyToPixels(this._potentialEnergyPeak));
        this._potentialEnergyLine.lineTo((float)(d - this._energyWellWidth / 2.0), (float)this.convertEnergyToPixels(this._energyWellBottom));
        this._potentialEnergyLine.lineTo((float)(d + this._energyWellWidth / 2.0), (float)this.convertEnergyToPixels(this._energyWellBottom));
        this._potentialEnergyLine.lineTo((float)(d + this._energyWellWidth / 2.0), (float)this.convertEnergyToPixels(this._potentialEnergyPeak));
        this._potentialEnergyLine.quadTo((float)(d + this._energyWellWidth / 2.0) + 25.0f, (float)this.convertEnergyToPixels(0.0), (float)(this._usableAreaOriginX + this._usableWidth - 18.0), (float)this.convertEnergyToPixels(this._potentialEnergyMinimum));
        this._potentialEnergyPeakRefLine.removeAllPoints();
        this._potentialEnergyPeakRefLine.addPoint(0, (float)(d + this._energyWellWidth / 2.0), (float)this.convertEnergyToPixels(this._potentialEnergyPeak));
        this._potentialEnergyPeakRefLine.addPoint(1, (float)(this._usableAreaOriginX + this._usableWidth * 0.95), (float)this.convertEnergyToPixels(this._potentialEnergyPeak));
        double d2 = this._usableHeight * 0.13;
        this._potentialEnergyPeakHandle.setScale(1.0);
        this._potentialEnergyPeakHandle.setScale(d2 / this._potentialEnergyPeakHandle.getFullBounds().height);
        this._potentialEnergyPeakHandle.setOffset(this._usableAreaOriginX + this._usableWidth * 0.9, (float)this.convertEnergyToPixels(this._potentialEnergyPeak));
        this._totalEnergyLine.removeAllPoints();
        double d3 = this.convertEnergyToPixels(this._totalEnergy);
        this._totalEnergyLine.addPoint(0, this._usableAreaOriginX + 18.0, d3);
        this._totalEnergyLine.addPoint(1, this._usableAreaOriginX + this._usableWidth - 18.0, d3);
        this._totalEnergyHandle.setScale(1.0);
        this._totalEnergyHandle.setScale(d2 / this._totalEnergyHandle.getFullBounds().height);
        this._totalEnergyHandle.setOffset(this._usableAreaOriginX + this._usableWidth * 0.95, d3);
        this._potentialEnergyPeakRefLine.setVisible(this._interactivityEnabled);
        if (!this._totalEnergyHandle.isVisible() && this._interactivityEnabled) {
            this._totalEnergyHandle.flash();
        }
        this._totalEnergyHandle.setVisible(this._interactivityEnabled);
        if (!this._potentialEnergyPeakHandle.isVisible() && this._interactivityEnabled) {
            this._potentialEnergyPeakHandle.flash();
        }
        this._potentialEnergyPeakHandle.setVisible(this._interactivityEnabled);
        AlphaDecayCompositeNucleus alphaDecayCompositeNucleus = this._model.getAtomNucleus();
        if (alphaDecayCompositeNucleus != null) {
            alphaDecayCompositeNucleus.setTunnelingRegionRadius(this.findEnergyLineIntersectionDistance());
        }
    }

    private void handleDecayEvent(ArrayList arrayList) {
        if (arrayList != null) {
            if (arrayList.size() == 1 && arrayList.get(0) instanceof AlphaParticle) {
                this._tunneledAlpha = (AlphaParticle)arrayList.get(0);
                this._tunneledAlphaParticleImage.setVisible(true);
                this.setAlphaImageOffset(this._tunneledAlphaParticleImage, this._tunneledAlpha);
                this._decayOccurred = true;
                if (this._currentlyTrackedAlphas.contains(this._tunneledAlpha)) {
                    int n = this._currentlyTrackedAlphas.indexOf(this._tunneledAlpha);
                    AlphaParticle alphaParticle = null;
                    for (int i = 0; i < this._alphaParticles.size(); ++i) {
                        alphaParticle = (AlphaParticle)this._alphaParticles.get(i);
                        if (this._currentlyTrackedAlphas.contains(alphaParticle)) continue;
                        this._currentlyTrackedAlphas.set(n, alphaParticle);
                        break;
                    }
                    this.setAlphaImageOffset(this._alphaParticleImages[n], alphaParticle);
                }
                this._energyWellBottom -= this._totalEnergy - -7.0;
                this.update();
            } else {
                System.err.println("Error: Unexpected decay event received.");
                assert (false);
            }
        }
    }

    private void handleModelElementAdded(Object object) {
        if (object instanceof CompositeAtomicNucleus) {
            this._model.getAtomNucleus().addListener(new AtomicNucleus.Adapter(){

                public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                    if (arrayList != null) {
                        AlphaDecayEnergyChart.this.handleDecayEvent(arrayList);
                    } else {
                        AlphaDecayEnergyChart.this._decayOccurred = false;
                        AlphaDecayEnergyChart.this._energyWellBottom = -37.0;
                        AlphaDecayEnergyChart.this._tunneledAlphaParticleImage.setVisible(false);
                        AlphaDecayEnergyChart.this.update();
                    }
                }
            });
            ArrayList arrayList = this._model.getAtomNucleus().getConstituents();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof AlphaParticle)) continue;
                this._alphaParticles.add(arrayList.get(i));
                if (this._currentlyTrackedAlphas.size() < 6) {
                    this._currentlyTrackedAlphas.add(arrayList.get(i));
                }
                ((AlphaParticle)arrayList.get(i)).addListener(this);
            }
            this._tunneledAlphaParticleImage.setVisible(false);
        }
        this._decayOccurred = false;
        this._totalEnergy = 8.0;
        this._potentialEnergyMinimum = 1.0;
        this._potentialEnergyPeak = 14.0;
        this._energyWellBottom = -37.0;
        if (this._usableHeight != 0.0 && this._usableWidth != 0.0) {
            this.update();
        }
    }

    private void handleModelElementRemoved(Object object) {
        if (object instanceof CompositeAtomicNucleus) {
            this._alphaParticles.clear();
            this._currentlyTrackedAlphas.clear();
        }
    }

    public void positionChanged(SubatomicParticle subatomicParticle) {
        assert (subatomicParticle instanceof AlphaParticle);
        if (this._tunneledAlpha != null && this._tunneledAlpha == subatomicParticle) {
            Point2D.Double double_ = this._tunneledAlpha.getPosition();
            double d = double_.distance(0.0, 0.0);
            PDimension pDimension = new PDimension(d, d);
            this._canvas.getPhetRootNode().worldToScreen(pDimension);
            double d2 = ((Point2D)double_).getX() < 0.0 ? -pDimension.getWidth() : pDimension.getWidth();
            if (Math.abs(d2) > this._usableWidth / 2.0) {
                this._tunneledAlphaParticleImage.setVisible(false);
                this._tunneledAlpha = null;
            } else {
                this.setAlphaImageOffset(this._tunneledAlphaParticleImage, this._tunneledAlpha);
            }
        } else if (subatomicParticle.getPosition().distance(0.0, 0.0) > this._model.getAtomNucleus().getDiameter() / 2.0 && subatomicParticle.getPosition().distance(0.0, 0.0) < this._model.getAtomNucleus().getTunnelingRegionRadius()) {
            if (!this._currentlyTrackedAlphas.contains(subatomicParticle)) {
                for (int i = 0; i < this._currentlyTrackedAlphas.size(); ++i) {
                    AlphaParticle alphaParticle = (AlphaParticle)this._currentlyTrackedAlphas.get(i);
                    if (!(alphaParticle.getPosition().distance(0.0, 0.0) <= this._model.getAtomNucleus().getDiameter() / 2.0)) continue;
                    this._currentlyTrackedAlphas.set(i, subatomicParticle);
                    this.setAlphaImageOffset(this._alphaParticleImages[i], subatomicParticle);
                    break;
                }
            } else {
                int n = this._currentlyTrackedAlphas.indexOf(subatomicParticle);
                this.setAlphaImageOffset(this._alphaParticleImages[n], subatomicParticle);
            }
        } else if (this._currentlyTrackedAlphas.contains(subatomicParticle)) {
            int n = this._currentlyTrackedAlphas.indexOf(subatomicParticle);
            this.setAlphaImageOffset(this._alphaParticleImages[n], subatomicParticle);
        }
    }

    private void refreshAlphaImages() {
        for (int i = 0; i < this._currentlyTrackedAlphas.size(); ++i) {
            this.positionChanged((AlphaParticle)this._currentlyTrackedAlphas.get(i));
        }
    }

    private void setAlphaImageOffset(PImage pImage, SubatomicParticle subatomicParticle) {
        assert (pImage != null);
        if (pImage == null) {
            return;
        }
        double d = !this._decayOccurred || subatomicParticle == this._tunneledAlpha ? this.convertEnergyToPixels(this._totalEnergy) : this.convertEnergyToPixels(-7.0);
        d -= pImage.getFullBounds().height / 2.0;
        Point2D.Double double_ = subatomicParticle.getPosition();
        double d2 = double_.distance(0.0, 0.0);
        PDimension pDimension = new PDimension(d2, d2);
        this._canvas.getPhetRootNode().worldToScreen(pDimension);
        double d3 = ((Point2D)double_).getX() < 0.0 ? this._usableWidth / 2.0 - pDimension.getWidth() : this._usableWidth / 2.0 + pDimension.getWidth();
        pImage.setOffset(d3, d);
    }

    private double calculateHalfLife() {
        double d;
        if (this._totalEnergy > this._potentialEnergyPeak) {
            d = 0.0;
        } else if (this._totalEnergy < 0.0) {
            d = Double.POSITIVE_INFINITY;
        } else {
            double d2 = (this._potentialEnergyPeak - this._totalEnergy) / 45.0;
            d = Math.pow(10.0, 24.0 * d2 - 0.5);
        }
        return d;
    }

    private double findEnergyLineIntersectionDistance() {
        double d = Double.POSITIVE_INFINITY;
        if (this._totalEnergy <= 0.0) {
            d = Double.POSITIVE_INFINITY;
        } else if (this._totalEnergy > this._potentialEnergyPeak) {
            d = 0.0;
        } else {
            double d2 = this.convertEnergyToPixels(this._totalEnergy);
            boolean bl = false;
            PathIterator pathIterator = this._potentialEnergyLine.getPathReference().getPathIterator(null, 0.001);
            double[] dArray = new double[2];
            while (!pathIterator.isDone() && !bl) {
                int n = pathIterator.currentSegment(dArray);
                switch (n) {
                    case 1: {
                        if (!(dArray[1] <= d2)) break;
                        d = this.convertPixelsToDistance(this._usableAreaOriginX + this._usableWidth / 2.0 - dArray[0]);
                        bl = true;
                        break;
                    }
                    case 0: 
                    case 4: {
                        break;
                    }
                    default: {
                        System.out.println("unexpected type: " + n);
                    }
                }
                pathIterator.next();
            }
        }
        return d;
    }

    private class GraphLegend
    extends PNode {
        private final double ENERGY_LINE_HORIZ_PROPORTION = 0.1;
        private final double TOTAL_ENERGY_VERT_PROPORTION = 0.5;
        private final double POTENTIAL_ENERGY_VERT_PROPORTION = 0.75;
        private final double ENERGY_LINE_LENGTH_PROPORTION = 0.15;
        private final PPath _background = new PPath();
        private final PText _title;
        private final PLine _potentialEnergyLine;
        private final PText _potentialEnergyLabel;
        private final PLine _totalEnergyLine;
        private final PText _totalEnergyLabel;

        public GraphLegend() {
            this._background.setStroke(LEGEND_BORDER_STROKE);
            this._background.setStrokePaint(LEGEND_BORDER_COLOR);
            this._background.setPaint(LEGEND_BACKGROUND_COLOR);
            this.addChild(this._background);
            this._title = new PText(NuclearPhysicsStrings.POTENTIAL_PROFILE_LEGEND_TITLE);
            this._title.setFont(new PhetFont(1, 14));
            this._background.addChild(this._title);
            this._potentialEnergyLine = new PLine();
            this._potentialEnergyLine.setStrokePaint(POTENTIAL_ENERGY_LINE_COLOR);
            this._potentialEnergyLine.setStroke(ENERGY_LINE_STROKE);
            this._background.addChild(this._potentialEnergyLine);
            this._potentialEnergyLabel = new PText(NuclearPhysicsStrings.POTENTIAL_PROFILE_POTENTIAL_ENERGY);
            this._potentialEnergyLabel.setFont(new PhetFont(0, 14));
            this._background.addChild(this._potentialEnergyLabel);
            this._totalEnergyLine = new PLine();
            this._totalEnergyLine.setStrokePaint(TOTAL_ENERGY_LINE_COLOR);
            this._totalEnergyLine.setStroke(ENERGY_LINE_STROKE);
            this._background.addChild(this._totalEnergyLine);
            this._totalEnergyLabel = new PText(NuclearPhysicsStrings.POTENTIAL_PROFILE_TOTAL_ENERGY);
            this._totalEnergyLabel.setFont(new PhetFont(0, 14));
            this._background.addChild(this._totalEnergyLabel);
        }

        public void updateSize(double d, double d2) {
            this._background.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, d2));
            this._title.setScale(1.0);
            double d3 = 1.0;
            d3 = d * 0.9 / this._title.getFullBoundsReference().width;
            if (this._title.getFullBoundsReference().height > d2 / 4.0) {
                d3 = Math.min(d2 / 4.0 / this._title.getFullBoundsReference().height, d3);
            }
            this._title.setScale(d3);
            this._title.setOffset(d / 2.0 - this._title.getFullBoundsReference().width / 2.0, 4.0);
            double d4 = 0.1 * d;
            double d5 = 0.15 * d;
            this._totalEnergyLine.removeAllPoints();
            this._totalEnergyLine.addPoint(0, d4, 0.5 * d2);
            this._totalEnergyLine.addPoint(1, d4 + d5, 0.5 * d2);
            this._totalEnergyLabel.setScale(1.0);
            if (this._totalEnergyLabel.getFullBoundsReference().height > d2 / 4.0) {
                this._totalEnergyLabel.setScale(d2 / 4.0 / this._totalEnergyLabel.getFullBoundsReference().height);
            }
            this._totalEnergyLabel.setOffset(this._totalEnergyLine.getFullBounds().getMaxX() + 10.0, this._totalEnergyLine.getFullBounds().getCenterY() - this._totalEnergyLabel.getFullBounds().height / 2.0);
            this._potentialEnergyLine.removeAllPoints();
            this._potentialEnergyLine.addPoint(0, d4, 0.75 * d2);
            this._potentialEnergyLine.addPoint(1, d4 + d5, 0.75 * d2);
            this._potentialEnergyLabel.setScale(1.0);
            if (this._potentialEnergyLabel.getFullBoundsReference().height > d2 / 4.0) {
                this._potentialEnergyLabel.setScale(d2 / 4.0 / this._potentialEnergyLabel.getFullBoundsReference().height);
            }
            this._potentialEnergyLabel.setOffset(this._potentialEnergyLine.getFullBounds().getMaxX() + 10.0, this._potentialEnergyLine.getFullBounds().getCenterY() - this._potentialEnergyLabel.getFullBounds().height / 2.0);
        }
    }
}

