/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.TimeDisplayNode;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimatedDatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItemNode;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricClosureState;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricDatingMeter;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricDatingMeterNode;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricMeasurementModel;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.SkyNode;
import edu.colorado.phet.nuclearphysics.view.NuclearDecayProportionChart;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public class RadiometricMeasurementCanvas
extends PhetPCanvas {
    private static final Dimension INITIAL_INTERMEDIATE_DIMENSION = new Dimension(786, 786);
    private static final Color START_OPERATION_BUTTON_COLOR = new Color(255, 204, 102);
    private static final Color FORCE_CLOSURE_BUTTON_COLOR = new Color(250, 70, 0);
    private static final PhetFont PLAY_AREA_BUTTON_FONT = new PhetFont(1, 24);
    private ModelViewTransform2D _mvt;
    private RadiometricMeasurementModel _model;
    private PNode _datableItemsLayer;
    private PNode _chartAndMeterLayer;
    private NuclearDecayProportionChart _proportionsChart;
    private RadiometricDatingMeterNode _meterNode;
    private IdentityHashMap<DatableItem, PNode> _mapModelElementsToNodes = new IdentityHashMap();
    private HTMLImageButtonNode _startOperationButtonNode;
    private HTMLImageButtonNode _forceClosureButtonNode;
    private HTMLImageButtonNode _resetButtonNode;
    private PPath _probeDragBounds = new PPath();
    private TimeDisplayNode _timeDisplay;

    RadiometricMeasurementCanvas(RadiometricMeasurementModel radiometricMeasurementModel) {
        this._model = radiometricMeasurementModel;
        this.setWorldTransformStrategy(new PhetPCanvas.CenterWidthScaleHeight(this, INITIAL_INTERMEDIATE_DIMENSION));
        this._mvt = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point(393, (int)Math.round(589.5)), 20.0, true);
        this._model.getMeter().addListener(new RadiometricDatingMeter.Adapter(){

            public void datingElementChanged() {
                RadiometricMeasurementCanvas.this.configureProportionsChart();
                RadiometricMeasurementCanvas.this.update();
            }

            public void touchedStateChanged() {
                RadiometricMeasurementCanvas.this.handleMeterTouchStateChanged();
            }

            public void measurementModeChanged() {
                if (RadiometricMeasurementCanvas.this._model.getMeter().getNucleusTypeUsedForDating() == NucleusType.CARBON_14 && RadiometricMeasurementCanvas.this._model.getMeter().getMeasurementMode() == RadiometricDatingMeter.MeasurementMode.AIR && RadiometricMeasurementCanvas.this._model.getSimulationMode() == RadiometricMeasurementModel.SIMULATION_MODE.ROCK) {
                    RadiometricMeasurementCanvas.this._proportionsChart.setLineModeEnabled(true);
                } else {
                    RadiometricMeasurementCanvas.this._proportionsChart.setLineModeEnabled(false);
                }
            }
        });
        this._model.addListener(new RadiometricMeasurementModel.Adapter(){

            public void modelElementAdded(Object object) {
                RadiometricMeasurementCanvas.this.handleModelElementAdded(object);
            }

            public void modelElementRemoved(Object object) {
                RadiometricMeasurementCanvas.this.handleModelElementRemoved(object);
            }

            public void simulationModeChanged() {
                RadiometricMeasurementCanvas.this.handleSimulationModeChanged();
            }

            public void closureStateChanged() {
                RadiometricMeasurementCanvas.this.updateButtonState();
            }
        });
        this._model.getClock().addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                RadiometricMeasurementCanvas.this.updateButtonState();
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                RadiometricMeasurementCanvas.this._proportionsChart.clear();
                RadiometricMeasurementCanvas.this._timeDisplay.setTime(0.0);
            }

            public void clockTicked(ClockEvent clockEvent) {
                RadiometricMeasurementCanvas.this.addDataToChart(clockEvent);
                RadiometricMeasurementCanvas.this.updateTimeDisplay(clockEvent);
            }
        });
        this.setBackground(NuclearPhysicsConstants.CANVAS_BACKGROUND);
        PNode pNode = new PNode();
        this.addWorldChild(pNode);
        this._datableItemsLayer = new PNode();
        this.addWorldChild(this._datableItemsLayer);
        this._chartAndMeterLayer = new PNode();
        this.addWorldChild(this._chartAndMeterLayer);
        GroundNode groundNode = new GroundNode();
        groundNode.setOffset(this._mvt.modelToViewXDouble(0.0), this._mvt.modelToViewYDouble(this._model.getGroundLevelY()));
        pNode.addChild(groundNode);
        SkyNode skyNode = new SkyNode(3144.0, 1179.0);
        skyNode.setOffset(this._mvt.modelToViewXDouble(0.0), this._mvt.modelToViewYDouble(this._model.getGroundLevelY()));
        pNode.addChild(skyNode);
        PImage pImage = NuclearPhysicsResources.getImageNode("cloud_1.png");
        pImage.setScale(0.75);
        pImage.setOffset(-110.0, 320.0);
        pNode.addChild(pImage);
        PImage pImage2 = NuclearPhysicsResources.getImageNode("cloud_1.png");
        pImage2.setScale(0.5);
        pImage2.setOffset(760.0, 380.0);
        pNode.addChild(pImage2);
        this._proportionsChart = new NuclearDecayProportionChart(false, false, false, false);
        this.configureProportionsChart();
        this._chartAndMeterLayer.addChild(this._proportionsChart);
        this._proportionsChart.componentResized(new Rectangle2D.Double(0.0, 0.0, 628.8000000000001, 235.79999999999998));
        this._proportionsChart.setOffset(188.78, 8.0);
        this._meterNode = new RadiometricDatingMeterNode(this._model.getMeter(), 180.78, 235.79999999999998, this._mvt, this, false, this._probeDragBounds);
        this._meterNode.setMeterBodyOffset(0.0, 8.0);
        this._chartAndMeterLayer.addChild(this._meterNode);
        this._timeDisplay = new TimeDisplayNode(220.0, 50.0);
        this._timeDisplay.setOffset(this._proportionsChart.getFullBoundsReference().getMaxX() - this._timeDisplay.getFullBoundsReference().width, this._proportionsChart.getFullBoundsReference().getMaxY() + 5.0);
        this._chartAndMeterLayer.addChild(this._timeDisplay);
        this._timeDisplay.setTime(0.0);
        this.updateButtonState();
        ArrayList arrayList = this._model.getModelElements();
        for (Object e : arrayList) {
            this.handleModelElementAdded(e);
        }
        this.initializeProbeLocation();
        this.addWorldChild(this._probeDragBounds);
    }

    protected void updateLayout() {
        AffineTransform affineTransform;
        super.updateLayout();
        AffineTransform affineTransform2 = this.getWorldTransformStrategy().getTransform();
        try {
            affineTransform = affineTransform2.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            System.err.println(this.getClass().getName() + " - Error: Unable to invert transform.");
            noninvertibleTransformException.printStackTrace();
            affineTransform = new AffineTransform();
        }
        Shape shape = affineTransform.createTransformedShape(this.getBounds());
        this._probeDragBounds.setPathTo(shape);
    }

    private void addDataToChart(ClockEvent clockEvent) {
        if (this._model.getMeter().getItemBeingTouched() != null) {
            double d = this._model.getAdjustedTime();
            this._proportionsChart.addDataPoint(d, this._model.getMeter().getPercentageOfDatingElementRemaining());
        }
    }

    private void updateTimeDisplay(ClockEvent clockEvent) {
        this._timeDisplay.setTime(this._model.getAdjustedTime());
    }

    private void handleModelElementAdded(Object object) {
        if (!this._mapModelElementsToNodes.containsKey(object)) {
            if (object instanceof AnimatedDatableItem) {
                AnimatedDatableItem animatedDatableItem = (AnimatedDatableItem)object;
                DatableItemNode datableItemNode = new DatableItemNode(animatedDatableItem, this._mvt);
                this._mapModelElementsToNodes.put(animatedDatableItem, datableItemNode);
                this._datableItemsLayer.addChild(datableItemNode);
            } else assert (false);
        } else {
            System.err.println(this.getClass().getName() + " - Error: Redundant attempt to add model element " + object.toString());
            assert (false);
        }
    }

    private void handleModelElementRemoved(Object object) {
        if (this._mapModelElementsToNodes.containsKey(object)) {
            PNode pNode = this._mapModelElementsToNodes.get(object);
            this._datableItemsLayer.removeChild(pNode);
            this._mapModelElementsToNodes.remove(object);
        }
    }

    private void handleSimulationModeChanged() {
        this.updateButtonState();
        this.initializeProbeLocation();
    }

    private void initializeProbeLocation() {
        if (this._model.getSimulationMode() == RadiometricMeasurementModel.SIMULATION_MODE.TREE) {
            this._model.getMeter().getProbeModel().setTipLocation(new Point2D.Double(0.0, -4.0));
        } else {
            this._model.getMeter().getProbeModel().setTipLocation(new Point2D.Double(-6.0, -2.0));
        }
    }

    private void updateButtonState() {
        if (this._startOperationButtonNode != null) {
            this._chartAndMeterLayer.removeChild(this._startOperationButtonNode);
            this._startOperationButtonNode = null;
        }
        if (this._forceClosureButtonNode != null) {
            this._chartAndMeterLayer.removeChild(this._forceClosureButtonNode);
            this._forceClosureButtonNode = null;
        }
        if (this._resetButtonNode != null) {
            this._chartAndMeterLayer.removeChild(this._resetButtonNode);
            this._resetButtonNode = null;
        }
        if (!this._model.getClock().isRunning()) {
            switch (this._model.getSimulationMode()) {
                case TREE: {
                    this._startOperationButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.PLANT_TREE, PLAY_AREA_BUTTON_FONT, START_OPERATION_BUTTON_COLOR);
                    break;
                }
                case ROCK: {
                    this._startOperationButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.ERUPT_VOLCANO, PLAY_AREA_BUTTON_FONT, START_OPERATION_BUTTON_COLOR);
                }
            }
            this._startOperationButtonNode.setOffset(786.0 - this._startOperationButtonNode.getFullBoundsReference().width, 766.0 - this._startOperationButtonNode.getFullBoundsReference().height);
            this._chartAndMeterLayer.addChild(this._startOperationButtonNode);
            this._startOperationButtonNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RadiometricMeasurementCanvas.this._model.startOperation();
                }
            });
        } else if (this._model.getRadiometricClosureState() == RadiometricClosureState.CLOSURE_POSSIBLE) {
            switch (this._model.getSimulationMode()) {
                case TREE: {
                    this._forceClosureButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.KILL_TREE, PLAY_AREA_BUTTON_FONT, FORCE_CLOSURE_BUTTON_COLOR);
                    break;
                }
                case ROCK: {
                    this._forceClosureButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.COOL_ROCK, PLAY_AREA_BUTTON_FONT, FORCE_CLOSURE_BUTTON_COLOR);
                }
            }
            this._forceClosureButtonNode.setOffset(786.0 - this._forceClosureButtonNode.getFullBoundsReference().width, 766.0 - this._forceClosureButtonNode.getFullBoundsReference().height);
            this._chartAndMeterLayer.addChild(this._forceClosureButtonNode);
            this._forceClosureButtonNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RadiometricMeasurementCanvas.this._model.forceClosure();
                }
            });
        } else if (this._model.getRadiometricClosureState() == RadiometricClosureState.CLOSED) {
            this._resetButtonNode = new HTMLImageButtonNode(NuclearPhysicsStrings.RESET_BUTTON_LABEL, PLAY_AREA_BUTTON_FONT, NuclearPhysicsConstants.CANVAS_RESET_BUTTON_COLOR);
            this._resetButtonNode.setOffset(786.0 - this._resetButtonNode.getFullBoundsReference().width, 766.0 - this._resetButtonNode.getFullBoundsReference().height);
            this._chartAndMeterLayer.addChild(this._resetButtonNode);
            this._resetButtonNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RadiometricMeasurementCanvas.this._model.resetOperation();
                }
            });
        }
    }

    private void handleMeterTouchStateChanged() {
        DatableItem datableItem = this._model.getMeter().getItemBeingTouched();
        if (datableItem != null) {
            // empty if block
        }
    }

    private void configureProportionsChart() {
        double d = this._model.getMeter().getHalfLifeForDating();
        this._proportionsChart.setTimeParameters(d * 3.2, d);
        this._proportionsChart.setDisplayInfoForNucleusType(this._model.getMeter().getNucleusTypeUsedForDating());
        if (this._model.getMeter().getNucleusTypeUsedForDating() == NucleusType.CARBON_14) {
            this._proportionsChart.setShowCarbonOptions(true);
        } else {
            this._proportionsChart.setShowCarbonOptions(false);
        }
    }

    private static class GroundNode
    extends PNode {
        public GroundNode() {
            PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, 3144.0, 786.0));
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(0, 100, 0), 0.0f, 196.5f, new Color(120, 255, 60), false);
            pPath.setPaint(gradientPaint);
            pPath.setOffset(-1572.0, 0.0);
            this.addChild(pPath);
        }
    }
}

