/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricDatingMeter;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PComboBox;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class RadiometricDatingMeterNode
extends PNode {
    private static final Color BODY_COLOR = Color.DARK_GRAY;
    private static final Font HALF_LIFE_SELECTION_FONT = new PhetFont(16);
    private static final ValueStringPair[] HALF_LIFE_VALUE_STRING_PAIRS = new ValueStringPair[]{new ValueStringPair(NuclearPhysicsConstants.DEFAULT_CUSTOM_NUCLEUS_HALF_LIFE, NuclearPhysicsStrings.HALF_LIFE_100_THOUSAND_YEARS), new ValueStringPair(HalfLifeInfo.convertYearsToMs(1000000.0), NuclearPhysicsStrings.HALF_LIFE_1_MILLION_YEARS), new ValueStringPair(HalfLifeInfo.convertYearsToMs(1.0E7), NuclearPhysicsStrings.HALF_LIFE_10_MILLION_YEARS), new ValueStringPair(HalfLifeInfo.convertYearsToMs(1.0E8), NuclearPhysicsStrings.HALF_LIFE_100_MILLION_YEARS)};
    private RadiometricDatingMeter _meterModel;
    private ModelViewTransform2D _mvt;
    private PNode _airProbeLayer;
    private PNode _meterBody;
    private ProbeNode _objectProbeNode;
    private ProbeCableNode _cableNode;
    private PercentageDisplayNode _percentageDisplay;
    private ElementSelectionPanel _elementSelectionPanel;
    private PSwing _elementSelectionNode;
    private PComboBox _halfLifeComboBox;
    private PSwing _halfLifeComboBoxPSwing = null;
    private PNode _airProbeNode;
    private MeasurementModeToggleAnimationTimer _animationTimer = null;
    private PText _halfLifeSelectionLabel;
    private boolean _showCustom = false;

    public RadiometricDatingMeterNode(RadiometricDatingMeter radiometricDatingMeter, double d, double d2, ModelViewTransform2D modelViewTransform2D, PSwingCanvas pSwingCanvas, boolean bl, PNode pNode) {
        this._meterModel = radiometricDatingMeter;
        this._mvt = modelViewTransform2D;
        this._showCustom = bl;
        this._meterModel.addListener(new RadiometricDatingMeter.Adapter(){

            public void datingElementChanged() {
                RadiometricDatingMeterNode.this.handleDatingElementChanged();
            }

            public void touchedStateChanged() {
                RadiometricDatingMeterNode.this.updateMeterReading();
            }

            public void readingChanged() {
                RadiometricDatingMeterNode.this.updateMeterReading();
            }

            public void measurementModeChanged() {
                RadiometricDatingMeterNode.this.handleMeasurementModeChanged();
            }
        });
        this._airProbeLayer = new PNode();
        this.addChild(this._airProbeLayer);
        this._meterBody = new PNode();
        this.addChild(this._meterBody);
        PPath pPath = new PPath(new RoundRectangle2D.Double(0.0, 0.0, d, d2, d / 5.0, d / 5.0));
        pPath.setPaint(BODY_COLOR);
        this._meterBody.addChild(pPath);
        this._percentageDisplay = new PercentageDisplayNode(d * 0.8, d2 * 0.16);
        this._percentageDisplay.setOffset(pPath.getFullBounds().width / 2.0 - this._percentageDisplay.getFullBounds().width / 2.0, pPath.getHeight() * 0.06);
        this._meterBody.addChild(this._percentageDisplay);
        this._percentageDisplay.setPercentage(100.0);
        this._elementSelectionPanel = new ElementSelectionPanel(radiometricDatingMeter, this._showCustom);
        this._elementSelectionNode = new PSwing(this._elementSelectionPanel);
        double d3 = Math.min(this._meterBody.getFullBoundsReference().width * 0.8 / this._elementSelectionNode.getFullBoundsReference().width, this._meterBody.getFullBoundsReference().height * 0.5 / this._elementSelectionNode.getFullBoundsReference().height);
        this._elementSelectionNode.setScale(d3);
        this._elementSelectionNode.setOffset(this._meterBody.getFullBounds().width / 2.0 - this._elementSelectionNode.getFullBounds().width / 2.0, this._percentageDisplay.getFullBounds().getMaxY());
        this._meterBody.addChild(this._elementSelectionNode);
        if (this._showCustom) {
            this._halfLifeComboBox = new PComboBox(HALF_LIFE_VALUE_STRING_PAIRS);
            this._halfLifeComboBox.setFont(HALF_LIFE_SELECTION_FONT);
            this._halfLifeComboBoxPSwing = new PSwing(this._halfLifeComboBox);
            this._halfLifeComboBox.setEnvironment(this._halfLifeComboBoxPSwing, pSwingCanvas);
            this._meterBody.addChild(this._halfLifeComboBoxPSwing);
            this._halfLifeComboBoxPSwing.setOffset(this._elementSelectionNode.getFullBoundsReference().getMaxX() - this._halfLifeComboBoxPSwing.getFullBoundsReference().width, this._elementSelectionNode.getFullBoundsReference().getMaxY());
            this._halfLifeSelectionLabel = new PText(NuclearPhysicsStrings.METER_HALF_LIFE_EQUALS);
            this._halfLifeSelectionLabel.setFont(HALF_LIFE_SELECTION_FONT);
            this._halfLifeSelectionLabel.setTextPaint(Color.WHITE);
            this._halfLifeSelectionLabel.setOffset(this._halfLifeComboBoxPSwing.getXOffset() - this._halfLifeSelectionLabel.getFullBoundsReference().width, this._elementSelectionNode.getFullBoundsReference().getMaxY());
            this._meterBody.addChild(this._halfLifeSelectionLabel);
            this._halfLifeComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RadiometricDatingMeterNode.this.handleUserChangedHalfLife();
                }
            });
            this._halfLifeComboBox.setEnabled(false);
        }
        MeasurementSelectionPanel measurementSelectionPanel = new MeasurementSelectionPanel(radiometricDatingMeter, this);
        PSwing pSwing = new PSwing(measurementSelectionPanel);
        pSwing.setScale(this._meterBody.getFullBoundsReference().width * 0.8 / pSwing.getFullBoundsReference().width);
        pSwing.setOffset(this._meterBody.getFullBoundsReference().width / 2.0 - pSwing.getFullBoundsReference().width / 2.0, this._meterBody.getFullBoundsReference().getMaxY() - pSwing.getFullBoundsReference().height * 1.1);
        this._meterBody.addChild(pSwing);
        this._objectProbeNode = new ProbeNode(this._meterModel.getProbeModel(), this._mvt, pNode);
        this.addChild(this._objectProbeNode);
        this._cableNode = new ProbeCableNode(this);
        this.addChild(this._cableNode);
        this._airProbeNode = new PImage(NuclearPhysicsResources.getImage("air_probe.png"));
        double d4 = this._meterBody.getFullBoundsReference().getHeight() * 0.5 / this._airProbeNode.getFullBoundsReference().height;
        this._airProbeNode.setScale(d4);
        this.setAirProbeExtensionAmount(0.0);
        this._airProbeLayer.addChild(this._airProbeNode);
        this.updateProbeVisibility();
        this.updateMeterReading();
        this.updateHalfLifeSelectorVisibility();
    }

    private void handleUserChangedHalfLife() {
        this._meterModel.setHalfLifeForCustomNucleus(RadiometricDatingMeterNode.HALF_LIFE_VALUE_STRING_PAIRS[this._halfLifeComboBox.getSelectedIndex()].value);
    }

    private void handleDatingElementChanged() {
        if (this._halfLifeComboBox != null) {
            if (this._meterModel.getNucleusTypeUsedForDating() == NucleusType.HEAVY_CUSTOM) {
                this._halfLifeComboBox.setEnabled(true);
                if (this._halfLifeComboBox.getSelectedIndex() == -1) {
                    this._halfLifeComboBox.setSelectedIndex(0);
                }
            } else {
                this._halfLifeComboBox.setEnabled(false);
            }
        }
        this.updateMeterReading();
        this.updateHalfLifeSelectorVisibility();
    }

    private void updateHalfLifeSelectorVisibility() {
        if (this._showCustom) {
            this._halfLifeComboBoxPSwing.setVisible(this._meterModel.getNucleusTypeUsedForDating() == NucleusType.HEAVY_CUSTOM);
            this._halfLifeSelectionLabel.setVisible(this._meterModel.getNucleusTypeUsedForDating() == NucleusType.HEAVY_CUSTOM);
        }
    }

    private void handleMeasurementModeChanged() {
        this.updateProbeVisibility();
    }

    private void updateProbeVisibility() {
        switch (this._meterModel.getMeasurementMode()) {
            case AIR: {
                this._airProbeNode.setVisible(true);
                this._objectProbeNode.setVisible(false);
                this._cableNode.setVisible(false);
                break;
            }
            case OBJECTS: {
                this._airProbeNode.setVisible(false);
                this._objectProbeNode.setVisible(true);
                this._cableNode.setVisible(true);
            }
        }
    }

    private void setAirProbeExtensionAmount(double d) {
        if (d < 0.0 || d > 1.0) {
            System.err.println(this.getClass().getName() + " - Error: Invalid extension amount");
            assert (false);
            return;
        }
        PBounds pBounds = this._meterBody.getFullBounds();
        PBounds pBounds2 = this._airProbeNode.getFullBounds();
        double d2 = this._airProbeNode.getFullBoundsReference().height * 0.333;
        this._airProbeNode.setOffset(pBounds.getWidth() / 2.0 - pBounds2.width / 2.0, pBounds.height - pBounds2.height + d * d2);
    }

    private ProbeNode getProbeNode() {
        return this._objectProbeNode;
    }

    private void updateMeterReading() {
        DatableItem datableItem = this._meterModel.getItemBeingTouched();
        if (datableItem == null) {
            this._percentageDisplay.setBlank();
        } else {
            this._percentageDisplay.setPercentage(this._meterModel.getPercentageOfDatingElementRemaining());
        }
    }

    private void startProbeChangeAnimation() {
        RadiometricDatingMeter.MeasurementMode measurementMode = this._meterModel.getMeasurementMode() == RadiometricDatingMeter.MeasurementMode.AIR ? RadiometricDatingMeter.MeasurementMode.OBJECTS : RadiometricDatingMeter.MeasurementMode.AIR;
        this._animationTimer = new MeasurementModeToggleAnimationTimer(this, measurementMode);
    }

    public void setMeterBodyOffset(double d, double d2) {
        this._meterBody.setOffset(d, d2);
        this._airProbeLayer.setOffset(d, d2);
    }

    private PNode getMeterBodyNode() {
        return this._meterBody;
    }

    private class ElementSelectionPanel
    extends VerticalLayoutPanel {
        private final Font LABEL_FONT = new PhetFont(16, true);

        public ElementSelectionPanel(final RadiometricDatingMeter radiometricDatingMeter, boolean bl) {
            this.setBackground(BODY_COLOR);
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NuclearPhysicsStrings.METER_PROBE_TYPE, 2, 2, this.LABEL_FONT, Color.WHITE);
            this.setBorder(titledBorder);
            final JRadioButton jRadioButton = new JRadioButton(NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.CARBON_14).getName(), true);
            jRadioButton.setBackground(BODY_COLOR);
            jRadioButton.setForeground(Color.WHITE);
            jRadioButton.setFont(this.LABEL_FONT);
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    radiometricDatingMeter.setNucleusTypeUsedForDating(NucleusType.CARBON_14);
                }
            });
            this.add(jRadioButton);
            radiometricDatingMeter.addListener(new RadiometricDatingMeter.Adapter(){

                public void datingElementChanged() {
                    jRadioButton.setSelected(radiometricDatingMeter.getNucleusTypeUsedForDating() == NucleusType.CARBON_14);
                }
            });
            jRadioButton.setSelected(radiometricDatingMeter.getNucleusTypeUsedForDating() == NucleusType.CARBON_14);
            final JRadioButton jRadioButton2 = new JRadioButton(NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.URANIUM_238).getName(), true);
            jRadioButton2.setBackground(BODY_COLOR);
            jRadioButton2.setForeground(Color.WHITE);
            jRadioButton2.setFont(this.LABEL_FONT);
            jRadioButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    radiometricDatingMeter.setNucleusTypeUsedForDating(NucleusType.URANIUM_238);
                }
            });
            this.add(jRadioButton2);
            radiometricDatingMeter.addListener(new RadiometricDatingMeter.Adapter(){

                public void datingElementChanged() {
                    jRadioButton2.setSelected(radiometricDatingMeter.getNucleusTypeUsedForDating() == NucleusType.URANIUM_238);
                }
            });
            jRadioButton2.setSelected(radiometricDatingMeter.getNucleusTypeUsedForDating() == NucleusType.URANIUM_238);
            if (bl) {
                final JRadioButton jRadioButton3 = new JRadioButton(NucleusDisplayInfo.getDisplayInfoForNucleusType(NucleusType.HEAVY_CUSTOM).getName(), true);
                jRadioButton3.setBackground(BODY_COLOR);
                jRadioButton3.setForeground(Color.WHITE);
                jRadioButton3.setFont(this.LABEL_FONT);
                jRadioButton3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        radiometricDatingMeter.setNucleusTypeUsedForDating(NucleusType.HEAVY_CUSTOM);
                    }
                });
                this.add(jRadioButton3);
                radiometricDatingMeter.addListener(new RadiometricDatingMeter.Adapter(){

                    public void datingElementChanged() {
                        jRadioButton3.setSelected(radiometricDatingMeter.getNucleusTypeUsedForDating() == NucleusType.HEAVY_CUSTOM);
                    }
                });
                jRadioButton3.setSelected(radiometricDatingMeter.getNucleusTypeUsedForDating() == NucleusType.HEAVY_CUSTOM);
            }
        }
    }

    private class MeasurementModeToggleAnimationTimer
    extends Timer {
        private RadiometricDatingMeterNode _meterNode;
        private RadiometricDatingMeter.MeasurementMode _targetMode;
        private int _animationCount;

        public MeasurementModeToggleAnimationTimer(RadiometricDatingMeterNode radiometricDatingMeterNode2, RadiometricDatingMeter.MeasurementMode measurementMode) {
            super(30, null);
            this._animationCount = 12;
            this._meterNode = radiometricDatingMeterNode2;
            this._targetMode = measurementMode;
            if (this._targetMode == RadiometricDatingMeter.MeasurementMode.AIR) {
                this._meterNode.setAirProbeExtensionAmount(0.0);
                this._meterNode._airProbeNode.setVisible(true);
                this._meterNode._objectProbeNode.setVisible(false);
                this._meterNode._cableNode.setVisible(false);
            } else {
                this._meterNode.setAirProbeExtensionAmount(1.0);
            }
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (MeasurementModeToggleAnimationTimer.this._animationCount <= 0) {
                        MeasurementModeToggleAnimationTimer.this.stop();
                        MeasurementModeToggleAnimationTimer.this._meterNode._meterModel.setMeasurementMode(MeasurementModeToggleAnimationTimer.this._targetMode);
                        MeasurementModeToggleAnimationTimer.this._meterNode._animationTimer = null;
                    } else {
                        MeasurementModeToggleAnimationTimer.this.stepAnimation(12 - MeasurementModeToggleAnimationTimer.this._animationCount);
                        MeasurementModeToggleAnimationTimer.this._animationCount--;
                    }
                }
            });
            this.start();
        }

        private void stepAnimation(int n) {
            if (this._targetMode == RadiometricDatingMeter.MeasurementMode.AIR) {
                this._meterNode.setAirProbeExtensionAmount(((double)n + 1.0) / 12.0);
            } else {
                this._meterNode.setAirProbeExtensionAmount(1.0 - ((double)n + 1.0) / 12.0);
            }
        }
    }

    private static class MeasurementSelectionPanel
    extends HorizontalLayoutPanel {
        private static final Font LABEL_FONT = new PhetFont(18, true);
        private final RadiometricDatingMeter _meterModel;
        private final JRadioButton _measureObjectsButton;
        private final JRadioButton _measureAirButton;

        public MeasurementSelectionPanel(RadiometricDatingMeter radiometricDatingMeter, final RadiometricDatingMeterNode radiometricDatingMeterNode) {
            this._meterModel = radiometricDatingMeter;
            this.setBackground(BODY_COLOR);
            BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
            this.setBorder(bevelBorder);
            this._measureObjectsButton = new JRadioButton(NuclearPhysicsStrings.MEASURE_OBJECTS, true);
            this._measureObjectsButton.setBackground(BODY_COLOR);
            this._measureObjectsButton.setForeground(Color.WHITE);
            this._measureObjectsButton.setFont(LABEL_FONT);
            this._measureObjectsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (MeasurementSelectionPanel.this._meterModel.getMeasurementMode() != RadiometricDatingMeter.MeasurementMode.OBJECTS) {
                        radiometricDatingMeterNode.startProbeChangeAnimation();
                    }
                }
            });
            this.add(this._measureObjectsButton);
            this._measureAirButton = new JRadioButton(NuclearPhysicsStrings.MEASURE_AIR, true);
            this._measureAirButton.setBackground(BODY_COLOR);
            this._measureAirButton.setForeground(Color.WHITE);
            this._measureAirButton.setFont(LABEL_FONT);
            this._measureAirButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (MeasurementSelectionPanel.this._meterModel.getMeasurementMode() != RadiometricDatingMeter.MeasurementMode.AIR) {
                        radiometricDatingMeterNode.startProbeChangeAnimation();
                    }
                    MeasurementSelectionPanel.this.updateButtonState();
                }
            });
            this.add(this._measureAirButton);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this._measureAirButton);
            buttonGroup.add(this._measureObjectsButton);
            radiometricDatingMeter.addListener(new RadiometricDatingMeter.Adapter(){

                public void measurementModeChanged() {
                    MeasurementSelectionPanel.this.updateButtonState();
                }
            });
            this.updateButtonState();
        }

        private void updateButtonState() {
            this._measureAirButton.setSelected(this._meterModel.getMeasurementMode() == RadiometricDatingMeter.MeasurementMode.AIR);
            this._measureObjectsButton.setSelected(this._meterModel.getMeasurementMode() == RadiometricDatingMeter.MeasurementMode.OBJECTS);
        }
    }

    private static class PercentageDisplayNode
    extends PNode {
        private final Color BACKGROUND_COLOR = new Color(255, 255, 255);
        private final Font TIME_FONT = new PhetFont(1, 26);
        private PPath _background;
        private RoundRectangle2D _backgroundShape;
        private double _currentPercentage;
        private PText _percentageText;
        private DecimalFormat _percentageFormatterOneDecimal = new DecimalFormat("##0.0");

        PercentageDisplayNode(double d, double d2) {
            this._backgroundShape = new RoundRectangle2D.Double(0.0, 0.0, d, d2, 8.0, 8.0);
            this._background = new PPath(this._backgroundShape);
            this._background.setPaint(this.BACKGROUND_COLOR);
            this.addChild(this._background);
            this._percentageText = new PText();
            this._percentageText.setFont(this.TIME_FONT);
            this.addChild(this._percentageText);
        }

        public void setPercentage(double d) {
            this._currentPercentage = d;
            this._percentageText.setText(this._percentageFormatterOneDecimal.format(this._currentPercentage) + " %");
            this.scaleAndCenterText();
        }

        public void setBlank() {
            this._percentageText.setText("-----");
            this.scaleAndCenterText();
        }

        private void scaleAndCenterText() {
            if (this._percentageText.getFullBoundsReference().width == 0.0 || this._percentageText.getFullBoundsReference().height == 0.0) {
                return;
            }
            this._percentageText.setScale(1.0);
            double d = Math.min(this._backgroundShape.getWidth() * 0.9 / this._percentageText.getFullBoundsReference().width, this._backgroundShape.getHeight() * 0.9 / this._percentageText.getFullBoundsReference().height);
            this._percentageText.setScale(d);
            this._percentageText.setOffset(this._background.getFullBoundsReference().width / 2.0 - this._percentageText.getFullBoundsReference().width / 2.0, this._background.getFullBoundsReference().height / 2.0 - this._percentageText.getFullBoundsReference().height / 2.0);
        }
    }

    private static class ProbeCableNode
    extends PhetPNode {
        private final ProbeNode _probeNode;
        private final PNode _meterBodyNode;
        private PPath _cable;

        public ProbeCableNode(RadiometricDatingMeterNode radiometricDatingMeterNode) {
            this._probeNode = radiometricDatingMeterNode.getProbeNode();
            this._meterBodyNode = radiometricDatingMeterNode.getMeterBodyNode();
            this._cable = new PPath();
            this._cable.setStroke(new BasicStroke(3.0f, 1, 1));
            this.addChild(this._cable);
            this._probeNode.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ProbeCableNode.this.update();
                }
            });
            this._meterBodyNode.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ProbeCableNode.this.update();
                }
            });
            this.update();
        }

        private void update() {
            Point2D.Double double_ = new Point2D.Double(this._probeNode.getTailLocation().getX(), this._probeNode.getTailLocation().getY());
            Point2D.Double double_2 = new Point2D.Double(this._meterBodyNode.getFullBoundsReference().getCenterX(), this._meterBodyNode.getFullBoundsReference().getMaxY());
            double d = double_2.distance(double_);
            if (d > 0.0) {
                DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(double_2);
                Vector2D vector2D = new MutableVector2D(double_2, double_).normalized();
                Vector2D vector2D2 = vector2D.getRotatedInstance(1.5707963267948966).normalized();
                this.lineToDst(doubleGeneralPath, vector2D, vector2D2, d / 5.0);
                this.curveToDst(doubleGeneralPath, vector2D, vector2D2, d / 5.0);
                this.lineToDst(doubleGeneralPath, vector2D, vector2D2, d / 5.0);
                this.curveToDst(doubleGeneralPath, vector2D, vector2D2, d / 5.0);
                doubleGeneralPath.lineTo(double_);
                this._cable.setPathTo(doubleGeneralPath.getGeneralPath());
            } else {
                this._cable.setPathTo(new Rectangle());
            }
        }

        private void curveToDst(DoubleGeneralPath doubleGeneralPath, Vector2D vector2D, Vector2D vector2D2, double d) {
            double d2 = d;
            if (d2 < 7.0) {
                d2 = 7.0;
            }
            if (d2 > 20.0) {
                d2 = 20.0;
            }
            double d3 = 15.0;
            Point2D point2D = doubleGeneralPath.getCurrentPoint();
            Point2D.Double double_ = vector2D.getInstanceOfMagnitude(d2).getDestination(point2D);
            Point2D.Double double_2 = vector2D.getInstanceOfMagnitude(d2 / 2.0).plus(vector2D2.getInstanceOfMagnitude(d3)).getDestination(point2D);
            doubleGeneralPath.quadTo(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY());
            doubleGeneralPath.quadTo(point2D.getX(), point2D.getY(), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        }

        private void lineToDst(DoubleGeneralPath doubleGeneralPath, Vector2D vector2D, Vector2D vector2D2, double d) {
            doubleGeneralPath.lineToRelative(vector2D.getInstanceOfMagnitude(d));
        }
    }

    static class ProbeNode
    extends PhetPNode {
        private final RadiometricDatingMeter.ObjectProbe _probeModel;
        private final PImage _imageNode;
        private final PhetPPath _tipPath;
        private final ModelViewTransform2D _mvt;
        private final PNode _dragBounds;

        public ProbeNode(RadiometricDatingMeter.ObjectProbe objectProbe, ModelViewTransform2D modelViewTransform2D, PNode pNode) {
            this._probeModel = objectProbe;
            this._mvt = modelViewTransform2D;
            this._dragBounds = pNode;
            this._imageNode = NuclearPhysicsResources.getImageNode("geiger_probe_6.png");
            this._imageNode.rotateAboutPoint(objectProbe.getAngle(), 0.1, 0.1);
            this._imageNode.scale(0.9);
            this.addChild(this._imageNode);
            objectProbe.addObserver(new SimpleObserver(){

                public void update() {
                    ProbeNode.this.updateProbe();
                }
            });
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseDragged(PInputEvent pInputEvent) {
                    ProbeNode.this.handleMouseDragged(pInputEvent);
                }
            });
            this.addInputEventListener(new CursorHandler());
            this._tipPath = new PhetPPath(Color.lightGray);
            this.addChild(this._tipPath);
            this.updateProbe();
        }

        private void handleMouseDragged(PInputEvent pInputEvent) {
            PDimension pDimension = pInputEvent.getDeltaRelativeTo(this.getParent());
            boolean bl = true;
            Rectangle2D rectangle2D = this.localToGlobal(this._dragBounds.getFullBounds());
            Rectangle2D rectangle2D2 = this.localToGlobal(this._imageNode.getFullBounds());
            if (pDimension.width > 0.0 && rectangle2D2.getMaxX() >= rectangle2D.getMaxX()) {
                bl = false;
            } else if (pDimension.width < 0.0 && rectangle2D2.getMinX() <= rectangle2D.getMinX()) {
                bl = false;
            }
            if (pDimension.height > 0.0 && rectangle2D2.getMaxY() >= rectangle2D.getMaxY()) {
                bl = false;
            } else if (pDimension.height < 0.0 && rectangle2D2.getMinY() <= rectangle2D.getMinY()) {
                bl = false;
            }
            if (bl) {
                this._probeModel.translate(this._mvt.viewToModelDifferentialX(pDimension.width), this._mvt.viewToModelDifferentialY(pDimension.height));
            }
        }

        private void updateProbe() {
            double d = (double)this._imageNode.getImage().getWidth(null) * 0.9 * Math.cos(this._probeModel.getAngle()) / 2.0;
            double d2 = (double)this._imageNode.getImage().getWidth(null) * 0.9 * Math.sin(this._probeModel.getAngle()) / 2.0;
            this._imageNode.setOffset(this._mvt.modelToViewXDouble(this._probeModel.getTipLocation().getX()) - d, this._mvt.modelToViewYDouble(this._probeModel.getTipLocation().getY()) - d2);
            this._tipPath.setPathTo(this._probeModel.getTipShape());
        }

        public Point2D getTailLocation() {
            Point2D.Double double_ = new Point2D.Double(this._imageNode.getWidth() / 2.0, this._imageNode.getHeight());
            this._imageNode.localToParent(double_);
            this.localToParent(double_);
            return new Point2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY());
        }
    }

    private static class ValueStringPair {
        public double value;
        public String string;

        public ValueStringPair(double d, String string) {
            this.value = d;
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }
}

