/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.ModelContainingDatableItems;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class RadiometricDatingMeter {
    private final ObjectProbe _probe;
    private DatableItem _itemBeingTouched = null;
    private ModelContainingDatableItems _model;
    private NucleusType _nucleusTypeForDating;
    private double _halfLifeOfCustomNucleus = NuclearPhysicsConstants.DEFAULT_CUSTOM_NUCLEUS_HALF_LIFE;
    private double _prevPercentageRemaining = Double.NaN;
    protected ArrayList<Listener> _listeners = new ArrayList();
    private ClockAdapter _clockListener;
    private MeasurementMode _measurementMode = MeasurementMode.OBJECTS;

    public RadiometricDatingMeter(ModelContainingDatableItems modelContainingDatableItems, Point2D point2D, boolean bl) {
        this._model = modelContainingDatableItems;
        this._probe = new ObjectProbe(point2D, 2.0);
        this._probe.addObserver(new SimpleObserver(){

            public void update() {
                RadiometricDatingMeter.this.updateTouchedItem();
            }
        });
        if (bl) {
            this._clockListener = new ClockAdapter(){

                public void clockTicked(ClockEvent clockEvent) {
                    RadiometricDatingMeter.this.updateState();
                }

                public void simulationTimeReset(ClockEvent clockEvent) {
                    RadiometricDatingMeter.this.updateState();
                }
            };
            this._model.getClock().addClockListener(this._clockListener);
        }
        this._nucleusTypeForDating = NucleusType.CARBON_14;
        this.updateTouchedItem();
    }

    public RadiometricDatingMeter(ModelContainingDatableItems modelContainingDatableItems) {
        this(modelContainingDatableItems, new Point2D.Double(-2.0, -5.0), false);
    }

    public ObjectProbe getProbeModel() {
        return this._probe;
    }

    public MeasurementMode getMeasurementMode() {
        return this._measurementMode;
    }

    public void setMeasurementMode(MeasurementMode measurementMode) {
        if (this._measurementMode != measurementMode) {
            this._measurementMode = measurementMode;
            this.notifyMeasurementModeChanged();
            this.updateTouchedItem();
        }
    }

    public void updateState() {
        this.updateTouchedItem();
        if (!(this.getPercentageOfDatingElementRemaining() == this._prevPercentageRemaining || Double.isNaN(this.getPercentageOfDatingElementRemaining()) && Double.isNaN(this._prevPercentageRemaining))) {
            this.notifyReadingChanged();
            this._prevPercentageRemaining = this.getPercentageOfDatingElementRemaining();
        }
    }

    public double getPercentageOfDatingElementRemaining() {
        if (this._itemBeingTouched == null) {
            return Double.NaN;
        }
        double d = this._nucleusTypeForDating == NucleusType.HEAVY_CUSTOM ? this._halfLifeOfCustomNucleus : HalfLifeInfo.getHalfLifeForNucleusType(this._nucleusTypeForDating);
        if (this._itemBeingTouched.isOrganic() && this._nucleusTypeForDating == NucleusType.URANIUM_238) {
            return 0.0;
        }
        if (!this._itemBeingTouched.isOrganic() && this._nucleusTypeForDating == NucleusType.CARBON_14) {
            return 0.0;
        }
        if (this._itemBeingTouched.getRadiometricAge() <= 0.0) {
            return 100.0;
        }
        return 100.0 * Math.exp(-0.693 * this._itemBeingTouched.getRadiometricAge() / d);
    }

    public void addListener(Listener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public DatableItem getItemBeingTouched() {
        if (this._measurementMode == MeasurementMode.AIR) {
            return this._model.getDatableAir();
        }
        return this._itemBeingTouched;
    }

    public void setNucleusTypeUsedForDating(NucleusType nucleusType) {
        this._nucleusTypeForDating = nucleusType;
        this.notifyDatingElementChanged();
    }

    public NucleusType getNucleusTypeUsedForDating() {
        return this._nucleusTypeForDating;
    }

    public void setHalfLifeForCustomNucleus(double d) {
        this._halfLifeOfCustomNucleus = d;
        this.notifyDatingElementChanged();
    }

    public double getHalfLifeForDating() {
        if (this._nucleusTypeForDating == NucleusType.HEAVY_CUSTOM) {
            return this._halfLifeOfCustomNucleus;
        }
        return HalfLifeInfo.getHalfLifeForNucleusType(this._nucleusTypeForDating);
    }

    private void updateTouchedItem() {
        if (this._measurementMode == MeasurementMode.OBJECTS) {
            DatableItem datableItem = this._model.getDatableItemAtLocation(this._probe.getTipLocation());
            if (this._itemBeingTouched != datableItem) {
                this._itemBeingTouched = datableItem;
                this.notifyTouchedStateChanged();
            }
        } else if (this._itemBeingTouched != this._model.getDatableAir()) {
            this._itemBeingTouched = this._model.getDatableAir();
            this.notifyTouchedStateChanged();
        }
    }

    private void notifyTouchedStateChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).touchedStateChanged();
        }
    }

    private void notifyReadingChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).readingChanged();
        }
    }

    private void notifyDatingElementChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).datingElementChanged();
        }
    }

    private void notifyMeasurementModeChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).measurementModeChanged();
        }
    }

    static class Adapter
    implements Listener {
        Adapter() {
        }

        public void touchedStateChanged() {
        }

        public void datingElementChanged() {
        }

        public void readingChanged() {
        }

        public void measurementModeChanged() {
        }
    }

    static interface Listener {
        public void touchedStateChanged();

        public void datingElementChanged();

        public void readingChanged();

        public void measurementModeChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MeasurementMode
    extends Enum<MeasurementMode> {
        public static final /* enum */ MeasurementMode OBJECTS = new MeasurementMode();
        public static final /* enum */ MeasurementMode AIR = new MeasurementMode();
        private static final /* synthetic */ MeasurementMode[] $VALUES;

        public static MeasurementMode[] values() {
            return (MeasurementMode[])$VALUES.clone();
        }

        static {
            $VALUES = new MeasurementMode[]{OBJECTS, AIR};
        }
    }

    public static class ObjectProbe
    extends SimpleObservable {
        private Point2D.Double tipLocation;
        private double angle;
        private double tipWidth = 0.034999999999999996;
        private double tipHeight = 0.28125;

        public ObjectProbe(Point2D point2D, double d) {
            this.tipLocation = new Point2D.Double(point2D.getX(), point2D.getY());
            this.angle = d;
        }

        public void translate(double d, double d2) {
            this.tipLocation.x += d;
            this.tipLocation.y += d2;
            this.notifyObservers();
        }

        public Point2D getTipLocation() {
            return new Point2D.Double(this.tipLocation.x, this.tipLocation.y);
        }

        public void setTipLocation(Point2D point2D) {
            this.tipLocation.x = point2D.getX();
            this.tipLocation.y = point2D.getY();
            this.notifyObservers();
        }

        public Shape getTipShape() {
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.tipLocation.x - this.tipWidth / 2.0, this.tipLocation.y, this.tipWidth, this.tipHeight);
            return AffineTransform.getRotateInstance(this.angle, this.tipLocation.x, this.tipLocation.y).createTransformedShape(double_);
        }

        public double getAngle() {
            return this.angle;
        }
    }
}

