/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimatedModelElement;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimationSequence;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.ModelAnimationDelta;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventObject;

public class ModelAnimationInterpreter {
    private final AnimatedModelElement modelElement;
    private final AnimationSequence animationSequence;
    private int maxEventsPerUpdate = Integer.MAX_VALUE;
    private ArrayList<Listener> _listeners = new ArrayList();

    public ModelAnimationInterpreter(AnimatedModelElement animatedModelElement, AnimationSequence animationSequence, int n) {
        this.modelElement = animatedModelElement;
        this.animationSequence = animationSequence;
        this.maxEventsPerUpdate = n;
    }

    public ModelAnimationInterpreter(AnimatedModelElement animatedModelElement, AnimationSequence animationSequence) {
        this(animatedModelElement, animationSequence, Integer.MAX_VALUE);
    }

    public void setTime(double d) {
        ArrayList<ModelAnimationDelta> arrayList = this.animationSequence.getNextAnimationDeltas(d);
        for (int i = 0; i < arrayList.size() && i < this.maxEventsPerUpdate; ++i) {
            this.interpret(arrayList.get(i));
        }
    }

    public void addListener(Listener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    protected void notifyAnimationEventOccurred(EventObject eventObject) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).animationNotificationEventOccurred(eventObject);
        }
    }

    private void interpret(ModelAnimationDelta modelAnimationDelta) {
        int n;
        if (modelAnimationDelta.getPrimaryImageIndexDelta() != 0) {
            n = this.modelElement.getNumberImages();
            this.modelElement.setPrimaryImageIndex((modelAnimationDelta.getPrimaryImageIndexDelta() + this.modelElement.getPrimaryImageIndex()) % n);
        }
        if (modelAnimationDelta.getSecondaryImageIndexDelta() != 0) {
            n = this.modelElement.getNumberImages();
            this.modelElement.setSecondaryImageIndex((modelAnimationDelta.getSecondaryImageIndexDelta() + this.modelElement.getSecondaryImageIndex()) % n);
        }
        if (modelAnimationDelta.getFadeFactorDelta() != 0.0) {
            double d = this.modelElement.getFadeFactor() + modelAnimationDelta.getFadeFactorDelta();
            d = MathUtil.clamp(0.0, d, 1.0);
            this.modelElement.setFadeFactor(d);
        }
        if (modelAnimationDelta.getPositionDelta() != null) {
            double d = this.modelElement.getPosition().getX() + modelAnimationDelta.getPositionDelta().getX();
            double d2 = this.modelElement.getPosition().getY() + modelAnimationDelta.getPositionDelta().getY();
            this.modelElement.setPosition(new Point2D.Double(d, d2));
        }
        if (modelAnimationDelta.getRotationDelta() != 0.0) {
            this.modelElement.setRotationalAngle(this.modelElement.getRotationalAngle() + modelAnimationDelta.getRotationDelta());
        }
        if (modelAnimationDelta.getSizeChangeFactor() != 1.0) {
            Dimension2D dimension2D = this.modelElement.getSize();
            dimension2D.setSize(dimension2D.getWidth() * modelAnimationDelta.getSizeChangeFactor(), dimension2D.getHeight() * modelAnimationDelta.getSizeChangeFactor());
            this.modelElement.setSize(dimension2D);
        }
        if (modelAnimationDelta.getEvent() != null) {
            this.notifyAnimationEventOccurred(modelAnimationDelta.getEvent());
        }
    }

    public static interface Listener {
        public void animationNotificationEventOccurred(EventObject var1);
    }
}

