/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadioactiveDatingGameModel;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.Stratum;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class EdgeOfWorldNode
extends PNode {
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private RadioactiveDatingGameModel _model;
    private ModelViewTransform2D _mvt;
    private PhetPPath _background;
    private ArrayList<EdgeStratumNode> _edgeStratumNodes = new ArrayList();

    public EdgeOfWorldNode(RadioactiveDatingGameModel radioactiveDatingGameModel, ModelViewTransform2D modelViewTransform2D) {
        this._model = radioactiveDatingGameModel;
        this._mvt = modelViewTransform2D;
        this._background = new PhetPPath(Color.DARK_GRAY, new BasicStroke(2.0f), Color.DARK_GRAY);
        this.addChild(this._background);
        Iterable<Stratum> iterable = this._model.getStratumIterable();
        int n = 0;
        for (Stratum stratum : iterable) {
            Color color = NuclearPhysicsConstants.strataColors.get(n % NuclearPhysicsConstants.strataColors.size());
            color = ColorUtils.darkerColor(color, 0.5);
            EdgeStratumNode edgeStratumNode = new EdgeStratumNode(stratum, color);
            this._edgeStratumNodes.add(edgeStratumNode);
            this.addChild(edgeStratumNode);
            ++n;
        }
    }

    public void updateEdgeShape(double d, double d2) {
        for (EdgeStratumNode edgeStratumNode : this._edgeStratumNodes) {
            edgeStratumNode.updateEdgeShape(d, d2);
        }
        this._background.setPathToRectangle((float)d2, this._mvt.modelToViewY((this._model.getBottomOfStrata() - this._model.getTopOfStrata()) / 2.0), (float)(d - d2 - 2.0), this._mvt.modelToViewDifferentialY((this._model.getBottomOfStrata() - this._model.getTopOfStrata()) / 2.0));
    }

    private class EdgeStratumNode
    extends PhetPPath {
        Stratum _stratum;

        public EdgeStratumNode(Stratum stratum, Color color) {
            super(color, STROKE, Color.BLACK);
            this._stratum = stratum;
        }

        public void updateEdgeShape(double d, double d2) {
            double d3 = -(Math.abs(d2 - d) * Math.tan(0.7225663103256524));
            GeneralPath generalPath = new GeneralPath();
            double d4 = this._stratum.getTopYGivenX(EdgeOfWorldNode.this._mvt.viewToModelX(d));
            double d5 = this._stratum.getBottomYGivenX(EdgeOfWorldNode.this._mvt.viewToModelX(d));
            generalPath.moveTo((float)d, (float)EdgeOfWorldNode.this._mvt.modelToViewYDouble(d4));
            generalPath.lineTo((float)d, (float)EdgeOfWorldNode.this._mvt.modelToViewYDouble(d5));
            generalPath.lineTo((float)d2, (float)(EdgeOfWorldNode.this._mvt.modelToViewYDouble(d5) + d3));
            generalPath.lineTo((float)d2, (float)(EdgeOfWorldNode.this._mvt.modelToViewYDouble(d4) + d3));
            generalPath.closePath();
            this.setPathTo(generalPath);
        }
    }
}

