/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimatedDatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimationSequence;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.ModelAnimationDelta;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.StaticAnimatedDatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.StaticAnimationSequence;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class AnimatedFlyingRock
extends StaticAnimatedDatableItem {
    private static final Random IMAGE_CHOICE_RAND = new Random();
    private static boolean firstOneCreated = true;
    private static boolean manImageUsed = false;

    public AnimatedFlyingRock(ConstantDtClock constantDtClock, Point2D point2D, double d, double d2) {
        super("Aging Rock", Arrays.asList(AnimatedFlyingRock.chooseInitialImage()), point2D, d, 0.0, 0.0, constantDtClock, d2, false);
        firstOneCreated = false;
    }

    protected AnimationSequence createAnimationSequence() {
        AnimatedDatableItem.TimeUpdater timeUpdater = new AnimatedDatableItem.TimeUpdater(0.0, HalfLifeInfo.convertHoursToMs(10.0));
        ArrayList<ModelAnimationDelta> arrayList = new ArrayList<ModelAnimationDelta>();
        Random random = new Random();
        int n = 50;
        double d = (random.nextDouble() - 0.5) * 0.3141592653589793;
        double d2 = 0.05 + random.nextDouble() * 0.09999999999999999;
        double d3 = (random.nextDouble() - 0.5) * 2.0 * 1.0;
        for (int i = 0; i < n; ++i) {
            double d4 = d2 * ((double)n * 0.42 - (double)i);
            arrayList.add(new ModelAnimationDelta(timeUpdater.updateTime(), new Point2D.Double(d3, d4), d, 1.0, 0, 0, 0.0, null));
        }
        return new StaticAnimationSequence(arrayList);
    }

    private static String chooseInitialImage() {
        double d = IMAGE_CHOICE_RAND.nextDouble();
        if (d > 0.95 && !firstOneCreated && !manImageUsed) {
            manImageUsed = true;
            return "moving-man.gif";
        }
        if (d > 0.5) {
            return "molten_rock.png";
        }
        return "molten_rock_large.png";
    }
}

