/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimatedDatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricClosureState;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class AgingRock
extends AnimatedDatableItem {
    private int _flyCounter = 50;
    private double _growthPerStep;
    private double _coolingStartPauseCounter = 50.0;
    private double _coolingCounter = 60.0;
    private boolean _closurePossibleSent = false;
    private boolean _closureOccurredSent = false;

    public AgingRock(ConstantDtClock constantDtClock, Point2D point2D, double d, double d2) {
        super("Aging Rock", Arrays.asList("rock_molten.png", "rock_cooled.png"), point2D, d, 0.0, 0.0, constantDtClock, d2, false);
        this._growthPerStep = Math.pow(10.0 / d, 0.02);
    }

    protected void handleClockTicked(ClockEvent clockEvent) {
        super.handleClockTicked(clockEvent);
        this.animate(this.getTotalAge());
    }

    private void animate(double d) {
        if (this._flyCounter > 0) {
            double d2 = -0.4;
            double d3 = ((double)this._flyCounter - 28.999999999999996) * 0.04;
            this.setPosition(this.getPosition().getX() + d2, this.getPosition().getY() + d3);
            Dimension2D dimension2D = this.getSize();
            dimension2D.setSize(dimension2D.getWidth() * this._growthPerStep, dimension2D.getHeight() * this._growthPerStep);
            this.setSize(dimension2D);
            this.setRotationalAngle(this.getRotationalAngle() + 0.5042256209011619);
            --this._flyCounter;
        } else if (this._flyCounter <= 0 && !this._closurePossibleSent) {
            this.setClosureState(RadiometricClosureState.CLOSURE_POSSIBLE);
            this._closurePossibleSent = true;
        } else if (this._coolingStartPauseCounter > 0.0) {
            if (this.getClosureState() != RadiometricClosureState.CLOSED) {
                this._coolingStartPauseCounter -= 1.0;
            } else {
                this._coolingStartPauseCounter = 0.0;
                this._closureOccurredSent = true;
            }
        } else if (this._coolingCounter > 0.0) {
            if (this.getClosureState() != RadiometricClosureState.CLOSED) {
                this.setFadeFactor(Math.min(this.getFadeFactor() + 0.016666666666666666, 1.0));
                this._coolingCounter -= 1.0;
            } else {
                this.setFadeFactor(1.0);
                this._coolingCounter = 0.0;
                this._closureOccurredSent = true;
            }
        } else if (!this._closureOccurredSent) {
            this.setClosureState(RadiometricClosureState.CLOSED);
            this._closureOccurredSent = true;
        }
    }
}

