/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.halflife;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.MultiNucleusDecayModel;
import edu.colorado.phet.nuclearphysics.model.Carbon14Nucleus;
import edu.colorado.phet.nuclearphysics.model.HeavyAdjustableHalfLifeNucleus;
import edu.colorado.phet.nuclearphysics.model.Uranium238Nucleus;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class RadiometricElementDecayModel
extends MultiNucleusDecayModel {
    static final NucleusType DEFAULT_NUCLEUS_TYPE = NucleusType.CARBON_14;
    private static final Rectangle2D BUCKET_RECT = new Rectangle2D.Double(40.0, 40.0, 45.0, 29.25);
    protected ArrayList _alphaParticles = new ArrayList();

    public RadiometricElementDecayModel(NuclearPhysicsClock nuclearPhysicsClock) {
        super(nuclearPhysicsClock, 99, DEFAULT_NUCLEUS_TYPE, true, new LabelVisibilityModel());
    }

    public Rectangle2D getBucketRectRef() {
        return BUCKET_RECT;
    }

    protected void addMaxNuclei() {
        double d = 62.5;
        double d2 = 54.625;
        for (int i = 0; i < this._maxNuclei; ++i) {
            AtomicNucleus atomicNucleus = this._currentNucleusType == NucleusType.CARBON_14 ? new Carbon14Nucleus(this._clock, new Point2D.Double(0.0, 0.0), true) : (this._currentNucleusType == NucleusType.URANIUM_238 ? new Uranium238Nucleus(this._clock) : new HeavyAdjustableHalfLifeNucleus(this._clock));
            this._atomicNuclei.add(atomicNucleus);
            atomicNucleus.setPosition(d, d2);
            this.notifyModelElementAdded(atomicNucleus);
            this._jitterOffsets[i] = new Point2D.Double();
            atomicNucleus.addListener(this._nucleusListener);
        }
    }
}

