/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.fissiononenucleus;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.CompositeAtomicNucleus;
import edu.colorado.phet.nuclearphysics.model.NeutronSource;
import edu.colorado.phet.nuclearphysics.model.Uranium235CompositeNucleus;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

public class FissionOneNucleusModel {
    private Uranium235CompositeNucleus _primaryNucleus;
    private CompositeAtomicNucleus _daughterNucleus;
    private NeutronSource _neutronSource;
    private ArrayList _freeNucleons = new ArrayList();
    private ArrayList _freeAlphas = new ArrayList();
    private ArrayList _listeners = new ArrayList();
    private ConstantDtClock _clock;
    private Random _rand = new Random();
    private MutableVector2D _initialParentAccel;
    private MutableVector2D _initialDaughterAccel;

    public FissionOneNucleusModel(NuclearPhysicsClock nuclearPhysicsClock) {
        this._primaryNucleus = new Uranium235CompositeNucleus(nuclearPhysicsClock, (Point2D)new Point2D.Double(0.0, 0.0), 1200.0);
        this._primaryNucleus.addListener(new AtomicNucleus.Adapter(){

            public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                FissionOneNucleusModel.this.handleAtomicWeightChanged(atomicNucleus, n, n2, arrayList);
            }
        });
        this._neutronSource = new NeutronSource(-30.0, 0.0);
        this._neutronSource.addListener(new NeutronSource.Adapter(){

            public void neutronGenerated(Nucleon nucleon) {
                FissionOneNucleusModel.this._freeNucleons.add(nucleon);
            }

            public void positionChanged() {
            }
        });
        this._clock = nuclearPhysicsClock;
        this._clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                FissionOneNucleusModel.this.handleClockTicked(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                FissionOneNucleusModel.this.reset();
            }
        });
    }

    public Uranium235CompositeNucleus getAtomicNucleus() {
        return this._primaryNucleus;
    }

    public NeutronSource getNeutronSource() {
        return this._neutronSource;
    }

    public ConstantDtClock getClock() {
        return this._clock;
    }

    public void addListener(Listener listener) {
        assert (!this._listeners.contains(listener));
        this._listeners.add(listener);
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        this.updateNucleiBehavior();
        for (int i = 0; i < this._freeNucleons.size(); ++i) {
            Nucleon nucleon = (Nucleon)this._freeNucleons.get(i);
            assert (nucleon instanceof Nucleon);
            nucleon.translate();
            if (!(Point2D.distance(nucleon.getPositionReference().getX(), nucleon.getPositionReference().getY(), this._primaryNucleus.getPositionReference().getX(), this._primaryNucleus.getPositionReference().getY()) < this._primaryNucleus.getDiameter() / 2.0) || !this._primaryNucleus.captureParticle(nucleon)) continue;
            this._freeNucleons.remove(i);
        }
    }

    private void reset() {
        this._primaryNucleus.reset(this._freeNucleons, this._daughterNucleus);
        if (this._daughterNucleus != null) {
            this._daughterNucleus.reset();
            this._daughterNucleus = null;
        }
        for (int i = 0; i < this._freeNucleons.size(); ++i) {
            for (int j = 0; j < this._listeners.size(); ++j) {
                ((Listener)this._listeners.get(j)).nucleonRemoved((Nucleon)this._freeNucleons.get(i));
            }
        }
        this._freeNucleons.clear();
    }

    private void handleAtomicWeightChanged(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                double d;
                double d2;
                double d3;
                Object e = arrayList.get(i);
                if (e instanceof Nucleon) {
                    d3 = this._rand.nextDouble() * Math.PI / 3.0;
                    if (this._rand.nextBoolean()) {
                        d3 += Math.PI;
                    }
                    d2 = Math.sin(d3) * 1.0;
                    d = Math.cos(d3) * 1.0;
                    ((Nucleon)e).setVelocity(d2, d);
                    this._freeNucleons.add(e);
                    continue;
                }
                if (e instanceof AlphaParticle) {
                    this._freeAlphas.add(e);
                    continue;
                }
                if (e instanceof AtomicNucleus) {
                    this._daughterNucleus = (CompositeAtomicNucleus)e;
                    d3 = this._rand.nextDouble() * Math.PI / 3.0 + 1.0471975511965976;
                    if (this._rand.nextBoolean()) {
                        d3 += Math.PI;
                    }
                    d2 = Math.sin(d3) * 0.05;
                    d = Math.cos(d3) * 0.05;
                    double d4 = Math.sin(d3) * 0.4;
                    double d5 = Math.cos(d3) * 0.4;
                    this._primaryNucleus.setVelocity(d2, d);
                    this._primaryNucleus.setAcceleration(d4, d5);
                    this._initialParentAccel = new MutableVector2D(d4, d5);
                    this._daughterNucleus.setVelocity(-d2, -d);
                    this._daughterNucleus.setAcceleration(-d4, -d5);
                    this._initialDaughterAccel = new MutableVector2D(-d4, -d5);
                    continue;
                }
                System.err.println("Error: Unexpected byproduct of decay event.");
                assert (false);
            }
        }
    }

    private void updateNucleiBehavior() {
        double d;
        if (this._daughterNucleus != null && (d = this._daughterNucleus.getPositionReference().distance(this._primaryNucleus.getPositionReference()) / this._primaryNucleus.getDiameter()) > 1.0) {
            double d2 = 1.0 / (d * d);
            this._daughterNucleus.setAcceleration(this._initialDaughterAccel.getX() * d2, this._initialDaughterAccel.getY() * d2);
            this._primaryNucleus.setAcceleration(this._initialParentAccel.getX() * d2, this._initialParentAccel.getY() * d2);
        }
    }

    public static interface Listener {
        public void nucleonRemoved(Nucleon var1);
    }
}

