/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.betadecay.singlenucleus;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.NuclearDecayModelListener;
import edu.colorado.phet.nuclearphysics.common.model.NucleusTypeControl;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import edu.colorado.phet.nuclearphysics.model.Carbon14CompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.CompositeAtomicNucleus;
import edu.colorado.phet.nuclearphysics.model.Hydrogen3CompositeNucleus;
import edu.colorado.phet.nuclearphysics.model.LightAdjustableCompositeNucleus;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class SingleNucleusBetaDecayModel
implements NucleusTypeControl {
    public NucleusType DEFAULT_NUCLEUS_TYPE = NucleusType.HYDROGEN_3;
    private CompositeAtomicNucleus _atomicNucleus;
    private NuclearPhysicsClock _clock;
    private ArrayList _listeners = new ArrayList();
    private NucleusType _nucleusType;
    private AtomicNucleus.Adapter _atomicNucleusAdapter;
    private ArrayList<SubatomicParticle> _emittedParticles = new ArrayList();
    private LabelVisibilityModel _labelVisibilityModel = new LabelVisibilityModel(true);

    public SingleNucleusBetaDecayModel(NuclearPhysicsClock nuclearPhysicsClock) {
        this._clock = nuclearPhysicsClock;
        this._nucleusType = this.DEFAULT_NUCLEUS_TYPE;
        nuclearPhysicsClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                SingleNucleusBetaDecayModel.this.handleClockTicked(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
                SingleNucleusBetaDecayModel.this.removeCurrentNucleus();
                NucleusType nucleusType = SingleNucleusBetaDecayModel.this._nucleusType;
                SingleNucleusBetaDecayModel.this._nucleusType = SingleNucleusBetaDecayModel.this.DEFAULT_NUCLEUS_TYPE;
                SingleNucleusBetaDecayModel.this.addNewNucleus();
                if (nucleusType != SingleNucleusBetaDecayModel.this.DEFAULT_NUCLEUS_TYPE) {
                    SingleNucleusBetaDecayModel.this.notifyNucleusTypeChanged();
                }
            }
        });
        this._atomicNucleusAdapter = new AtomicNucleus.Adapter(){

            public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Object e = arrayList.get(i);
                        if (e instanceof SubatomicParticle) {
                            SingleNucleusBetaDecayModel.this._emittedParticles.add((SubatomicParticle)e);
                            SingleNucleusBetaDecayModel.this.notifyModelElementAdded(e);
                            continue;
                        }
                        System.err.println("Error: Unexpected byproduct of decay event.");
                        assert (false);
                    }
                }
            }
        };
    }

    public CompositeAtomicNucleus getAtomNucleus() {
        return this._atomicNucleus;
    }

    public ConstantDtClock getClock() {
        return this._clock;
    }

    public void setNucleusType(NucleusType nucleusType) {
        if (this._nucleusType == nucleusType) {
            return;
        }
        this.removeCurrentNucleus();
        this._nucleusType = nucleusType;
        this.addNewNucleus();
        this.notifyNucleusTypeChanged();
    }

    public NucleusType getNucleusType() {
        return this._nucleusType;
    }

    public LabelVisibilityModel getLabelVisibilityModel() {
        return this._labelVisibilityModel;
    }

    public void resetNucleus() {
        this._atomicNucleus.reset();
        this._atomicNucleus.activateDecay();
    }

    public void addListener(NuclearDecayModelListener nuclearDecayModelListener) {
        assert (!this._listeners.contains(nuclearDecayModelListener));
        if (!this._listeners.contains(nuclearDecayModelListener)) {
            this._listeners.add(nuclearDecayModelListener);
        }
    }

    public double getHalfLife() {
        if (this._atomicNucleus != null) {
            return this._atomicNucleus.getHalfLife();
        }
        return 0.0;
    }

    public void setHalfLife(double d) {
        if (this._nucleusType != NucleusType.LIGHT_CUSTOM) {
            System.err.println(this.getClass().getName() + "- Warning: Can only set nucleus type for custom nucleus, ignoring request.");
            return;
        }
        LightAdjustableCompositeNucleus lightAdjustableCompositeNucleus = (LightAdjustableCompositeNucleus)this._atomicNucleus;
        lightAdjustableCompositeNucleus.setHalfLife(d);
        this.resetNucleus();
        this.notifyHalfLifeChanged();
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        for (SubatomicParticle subatomicParticle : this._emittedParticles) {
            subatomicParticle.translate();
        }
    }

    private void removeCurrentNucleus() {
        if (this._atomicNucleus != null) {
            this._atomicNucleus.removeListener(this._atomicNucleusAdapter);
            this._atomicNucleus.removedFromModel();
            CompositeAtomicNucleus compositeAtomicNucleus = this._atomicNucleus;
            this._atomicNucleus = null;
            this.notifyModelElementRemoved(compositeAtomicNucleus);
        }
        for (int i = 0; i < this._emittedParticles.size(); ++i) {
            this.notifyModelElementRemoved(this._emittedParticles.get(i));
        }
        this._emittedParticles.clear();
    }

    private void addNewNucleus() {
        if (this._atomicNucleus != null) {
            System.err.println("Warning: Removing existing nucleus before adding new one.");
            this.removeCurrentNucleus();
        }
        switch (this._nucleusType) {
            case HYDROGEN_3: {
                this._atomicNucleus = new Hydrogen3CompositeNucleus(this._clock, new Point2D.Double(0.0, 0.0));
                break;
            }
            case CARBON_14: {
                this._atomicNucleus = new Carbon14CompositeNucleus(this._clock, new Point2D.Double(0.0, 0.0));
                break;
            }
            case LIGHT_CUSTOM: {
                this._atomicNucleus = new LightAdjustableCompositeNucleus(this._clock, new Point2D.Double(0.0, 0.0));
            }
        }
        this._atomicNucleus.addListener(this._atomicNucleusAdapter);
        this._atomicNucleus.activateDecay();
        this.notifyModelElementAdded(this._atomicNucleus);
    }

    private void notifyModelElementRemoved(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).modelElementRemoved(object);
        }
    }

    private void notifyModelElementAdded(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).modelElementAdded(object);
        }
    }

    private void notifyNucleusTypeChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).nucleusTypeChanged();
        }
    }

    private void notifyHalfLifeChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((NuclearDecayModelListener)this._listeners.get(i)).halfLifeChanged();
        }
    }
}

