/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.betadecay;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.view.AntineutrinoNode;
import edu.colorado.phet.nuclearphysics.view.ElectronNode;
import edu.colorado.phet.nuclearphysics.view.StandaloneNeutronNode;
import edu.colorado.phet.nuclearphysics.view.StandaloneProtonNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class BetaDecayLegendPanel
extends JPanel {
    private int _numRows = 0;

    public BetaDecayLegendPanel() {
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NuclearPhysicsStrings.LEGEND_BORDER_LABEL, 1, 2, new PhetFont(1, 14), Color.GRAY);
        this.setBorder(titledBorder);
        this.setLayout(new GridBagLayout());
        StandaloneNeutronNode standaloneNeutronNode = new StandaloneNeutronNode();
        standaloneNeutronNode.scale(8.0);
        this.addLegendItem(standaloneNeutronNode.toImage(), NuclearPhysicsStrings.NEUTRON_LEGEND_LABEL);
        StandaloneProtonNode standaloneProtonNode = new StandaloneProtonNode();
        standaloneProtonNode.scale(8.0);
        this.addLegendItem(standaloneProtonNode.toImage(), NuclearPhysicsStrings.PROTON_LEGEND_LABEL);
        ElectronNode electronNode = new ElectronNode();
        electronNode.scale(8.0);
        this.addLegendItem(electronNode.toImage(), NuclearPhysicsStrings.ELECTRON_LEGEND_LABEL);
        AntineutrinoNode antineutrinoNode = new AntineutrinoNode();
        antineutrinoNode.scale(8.0);
        this.addLegendItem(antineutrinoNode.toImage(), NuclearPhysicsStrings.ANTINEUTRINO_LEGEND_LABEL);
    }

    private void addLegendItem(Image image, String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ImageIcon imageIcon = new ImageIcon(image);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this._numRows;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        this.add((Component)new JLabel(imageIcon), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this._numRows++;
        this.add((Component)new JLabel(string), gridBagConstraints);
    }
}

