/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.alphadecay.multinucleus;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.MultiNucleusDecayModel;
import edu.colorado.phet.nuclearphysics.model.AbstractAlphaDecayNucleus;
import edu.colorado.phet.nuclearphysics.model.AlphaParticle;
import edu.colorado.phet.nuclearphysics.model.HeavyAdjustableHalfLifeNucleus;
import edu.colorado.phet.nuclearphysics.model.Polonium211Nucleus;
import edu.colorado.phet.nuclearphysics.module.betadecay.LabelVisibilityModel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class MultiNucleusAlphaDecayModel
extends MultiNucleusDecayModel {
    static final NucleusType DEFAULT_NUCLEUS_TYPE = NucleusType.POLONIUM_211;
    private static final Rectangle2D BUCKET_RECT = new Rectangle2D.Double(43.0, 45.0, 45.0, 29.25);
    protected ArrayList _alphaParticles = new ArrayList();

    public MultiNucleusAlphaDecayModel(NuclearPhysicsClock nuclearPhysicsClock) {
        super(nuclearPhysicsClock, 99, DEFAULT_NUCLEUS_TYPE, true, new LabelVisibilityModel());
    }

    public Rectangle2D getBucketRectRef() {
        return BUCKET_RECT;
    }

    protected void handleClockTicked(ClockEvent clockEvent) {
        super.handleClockTicked(clockEvent);
        for (int i = 0; i < this._alphaParticles.size(); ++i) {
            ((AlphaParticle)this._alphaParticles.get(i)).moveOut();
        }
    }

    protected void addMaxNuclei() {
        double d = 65.5;
        double d2 = 59.625;
        for (int i = 0; i < this._maxNuclei; ++i) {
            AbstractAlphaDecayNucleus abstractAlphaDecayNucleus = this._currentNucleusType == NucleusType.POLONIUM_211 ? new Polonium211Nucleus(this._clock) : new HeavyAdjustableHalfLifeNucleus(this._clock);
            this._atomicNuclei.add(abstractAlphaDecayNucleus);
            abstractAlphaDecayNucleus.setPosition(d, d2);
            this.notifyModelElementAdded(abstractAlphaDecayNucleus);
            this._jitterOffsets[i] = new Point2D.Double();
            abstractAlphaDecayNucleus.addListener(this._nucleusListener);
        }
    }

    protected void initializeNucleusListener() {
        this._nucleusListener = new AtomicNucleus.Adapter(){

            public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Object e = arrayList.get(i);
                        if (e instanceof AlphaParticle) {
                            ((AlphaParticle)e).tunnelOut(atomicNucleus.getPositionReference(), 15.0);
                            MultiNucleusAlphaDecayModel.this._alphaParticles.add(e);
                            MultiNucleusAlphaDecayModel.this.notifyModelElementAdded(e);
                            continue;
                        }
                        System.err.println("Error: Unexpected byproduct of decay event.");
                        assert (false);
                    }
                }
            }
        };
    }

    protected void removeAllNuclei() {
        super.removeAllNuclei();
        for (int i = 0; i < this._alphaParticles.size(); ++i) {
            this.notifyModelElementRemoved(this._alphaParticles.get(i));
        }
        this._alphaParticles.clear();
    }
}

