/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.model.Nucleon;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class NeutronSource {
    private ArrayList _listeners = new ArrayList();
    private Point2D.Double _position;
    private double _firingAngle = 0.0;

    public NeutronSource(double d, double d2) {
        this._position = new Point2D.Double(d, d2);
    }

    public Point2D getPosition() {
        return new Point2D.Double(this._position.getX(), this._position.getY());
    }

    public void setPosition(double d, double d2) {
        if (d != this._position.getX() || d2 != this._position.getY()) {
            this._position.setLocation(d, d2);
            this.notifyPositionChanged();
        }
    }

    public double getFiringAngle() {
        return this._firingAngle;
    }

    public void setFiringAngle(double d) {
        if (d != this._firingAngle) {
            this._firingAngle = d;
            this.notifyOrientationChanged();
        }
    }

    public void addListener(Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    public void notifyPositionChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).positionChanged();
        }
    }

    public void notifyOrientationChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).orientationChanged();
        }
    }

    public void notifyNeutronGenerated(Nucleon nucleon) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ((Listener)this._listeners.get(i)).neutronGenerated(nucleon);
        }
    }

    public void generateNeutron() {
        Nucleon nucleon = new Nucleon(Nucleon.NucleonType.NEUTRON, this._position.x, this._position.y, 1.75 * Math.cos(this._firingAngle), 1.75 * Math.sin(this._firingAngle), false);
        this.notifyNeutronGenerated(nucleon);
    }

    public static class Adapter
    implements Listener {
        public void positionChanged() {
        }

        public void orientationChanged() {
        }

        public void neutronGenerated(Nucleon nucleon) {
        }
    }

    public static interface Listener {
        public void positionChanged();

        public void orientationChanged();

        public void neutronGenerated(Nucleon var1);
    }
}

