/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.model.CompositeAtomicNucleus;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class DaughterCompositeNucleus
extends CompositeAtomicNucleus {
    public DaughterCompositeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, ArrayList arrayList) {
        super(nuclearPhysicsClock, point2D, arrayList);
        this.setTunnelingRegionRadius(this.getDiameter() / 2.0 * 1.1);
    }

    public void reset() {
        this._constituents.clear();
        this._numAlphas = 0;
        this._numNeutrons = 0;
        this._numProtons = 0;
        this.notifyNucleusChangeEvent(null);
    }

    protected void updateAgitationFactor() {
        switch (this._numProtons) {
            case 36: {
                if (this._numNeutrons == 56) {
                    this._agitationFactor = 6;
                    break;
                }
                this._agitationFactor = 5;
                break;
            }
            default: {
                this._agitationFactor = 5;
            }
        }
    }
}

