/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.common.model.Antineutrino;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.common.model.Electron;
import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

public abstract class AbstractBetaDecayNucleus
extends AtomicNucleus {
    private static final Random RAND = new Random();

    public AbstractBetaDecayNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D, int n, int n2, double d) {
        super(nuclearPhysicsClock, point2D, n, n2, d);
    }

    protected void decay(ClockEvent clockEvent) {
        super.decay(clockEvent);
        --this._numNeutrons;
        ++this._numProtons;
        double d = RAND.nextDouble() * Math.PI * 2.0;
        double d2 = Math.cos(d) * 0.8;
        double d3 = Math.sin(d) * 0.8;
        ArrayList<SubatomicParticle> arrayList = new ArrayList<SubatomicParticle>();
        Electron electron = new Electron(this.getPositionReference().getX(), this.getPositionReference().getY());
        electron.setVelocity(d2, d3);
        arrayList.add(electron);
        d = RAND.nextDouble() * Math.PI * 2.0;
        d2 = Math.cos(d) * 1.5;
        d3 = Math.sin(d) * 1.5;
        Antineutrino antineutrino = new Antineutrino(this.getPositionReference().getX(), this.getPositionReference().getY());
        antineutrino.setVelocity(d2, d3);
        arrayList.add(antineutrino);
        this.notifyNucleusChangeEvent(arrayList);
    }

    public void reset() {
        super.reset();
        if (this._numNeutrons != this._origNumNeutrons || this._numProtons != this._origNumProtons) {
            ++this._numNeutrons;
            --this._numProtons;
            this.notifyNucleusChangeEvent(null);
        }
    }
}

