/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.common.model;

import edu.colorado.phet.nuclearphysics.common.model.SubatomicParticle;
import java.awt.geom.Point2D;
import java.util.Random;

public class Nucleon
extends SubatomicParticle {
    private static final Random RAND = new Random();
    private NucleonType _type;
    private boolean _tunnelingEnabled;
    private final Point2D.Double _jitterOffset = new Point2D.Double();

    public Nucleon(NucleonType nucleonType, double d, double d2, boolean bl) {
        this(nucleonType, d, d2, 0.0, 0.0, bl);
    }

    public Nucleon(NucleonType nucleonType, double d, double d2, double d3, double d4, boolean bl) {
        super(d, d2, d3, d4);
        this._type = nucleonType;
        this._tunnelingEnabled = bl;
    }

    public void setTunnelingEnabled(boolean bl) {
        this._tunnelingEnabled = bl;
    }

    public void setNucleonType(NucleonType nucleonType) {
        if (this._type != nucleonType) {
            this._type = nucleonType;
            this.notifyNucleonTypeChanged();
        }
    }

    public NucleonType getNucleonType() {
        return this._type;
    }

    public void tunnel(Point2D point2D, double d, double d2, double d3) {
        if (this._tunnelingEnabled) {
            double d4 = RAND.nextDouble();
            if (d4 > 0.8) {
                d4 = RAND.nextDouble() * RAND.nextDouble();
            }
            double d5 = d + d4 * (d2 - d);
            double d6 = RAND.nextDouble() * 2.0 * Math.PI;
            double d7 = Math.cos(d6) * d5;
            double d8 = Math.sin(d6) * d5;
            this.setPosition(d7 + point2D.getX(), d8 + point2D.getY());
        }
    }

    public void jitter() {
        if (this._jitterOffset.getX() == 0.0 && this._jitterOffset.getY() == 0.0) {
            double d = RAND.nextDouble() * 2.0 * Math.PI;
            this._jitterOffset.setLocation(Math.cos(d) * 0.16000000000000003, Math.sin(d) * 0.16000000000000003);
            this.setPosition(this.getPosition().x + this._jitterOffset.x, this.getPosition().y + this._jitterOffset.y);
        } else {
            this.setPosition(this.getPosition().x - this._jitterOffset.x, this.getPosition().y - this._jitterOffset.y);
            this._jitterOffset.setLocation(0.0, 0.0);
        }
    }

    protected void notifyNucleonTypeChanged() {
        for (SubatomicParticle.Listener listener : this._listeners) {
            if (!(listener instanceof NucleonListener)) continue;
            ((NucleonListener)listener).nucleonTypeChanged();
        }
    }

    public static class NucleonAdapter
    implements NucleonListener {
        public void nucleonTypeChanged() {
        }

        public void positionChanged(SubatomicParticle subatomicParticle) {
        }
    }

    public static interface NucleonListener
    extends SubatomicParticle.Listener {
        public void nucleonTypeChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NucleonType
    extends Enum<NucleonType> {
        public static final /* enum */ NucleonType PROTON = new NucleonType();
        public static final /* enum */ NucleonType NEUTRON = new NucleonType();
        private static final /* synthetic */ NucleonType[] $VALUES;

        public static NucleonType[] values() {
            return (NucleonType[])$VALUES.clone();
        }

        static {
            $VALUES = new NucleonType[]{PROTON, NEUTRON};
        }
    }
}

