/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.module.decayrates.DecayRatesModule;
import edu.colorado.phet.nuclearphysics.module.halflife.RadiometricElementDecayModule;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadioactiveDatingGameModule;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricMeasurementModule;

public class RadioactiveDatingGameApplication
extends PiccoloPhetApplication {
    private RadiometricElementDecayModule _radioactiveElementDecayModule;
    private DecayRatesModule _decayRatesModule;
    private RadiometricMeasurementModule _radiometricMeasurementModule;
    private RadioactiveDatingGameModule _radioactiveDatingGameModule;

    public RadioactiveDatingGameApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        PhetFrame phetFrame = this.getPhetFrame();
        this._radioactiveElementDecayModule = new RadiometricElementDecayModule(phetFrame);
        this.addModule(this._radioactiveElementDecayModule);
        this._decayRatesModule = new DecayRatesModule(phetFrame);
        this.addModule(this._decayRatesModule);
        this._radiometricMeasurementModule = new RadiometricMeasurementModule(phetFrame);
        this.addModule(this._radiometricMeasurementModule);
        this._radioactiveDatingGameModule = new RadioactiveDatingGameModule(phetFrame);
        this.addModule(this._radioactiveDatingGameModule);
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new RadioactiveDatingGameApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "nuclear-physics", "radioactive-dating-game");
        PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
        phetLookAndFeel.setBackgroundColor(NuclearPhysicsConstants.RADIOACTIVE_DATING_GAME_CONTROL_PANEL_COLOR);
        phetApplicationConfig.setLookAndFeel(phetLookAndFeel);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

